% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knt.R
\name{knt}
\alias{knt}
\title{Plot carrying capacity and abundance trajectories}
\usage{
knt(meta, kch, pops, samelims = FALSE, show_N = FALSE, results, ...)
}
\arguments{
\item{meta}{The R object holding population info returned by
\code{\link{meta}}.}

\item{kch}{The R object holding kch data returned by \code{\link{kch}}.}

\item{pops}{(Optional) A character vector of population names. The
metapopulation will be subset to these populations before plotting. If not
provided, all populations will be plotted (see Note below).}

\item{samelims}{(logical) If \code{TRUE}, the y-axis limits will be constant
across plots.}

\item{show_N}{(logical) If \code{TRUE}, mean population abundance will be
plotted (solid lines) in addition to carrying capacity (dashed lines).}

\item{results}{(required only if \code{show_N} is \code{TRUE}) The R object
holding simulation results returned by \code{\link{results}}.}

\item{...}{Additional arguments to \code{lattice::\link[lattice]{xyplot}},
e.g., \code{layout}.}
}
\value{
A lattice object is returned invisibly, and plotted if not assigned.
}
\description{
Plot each population's carrying capacity and abundance over time.
}
\note{
When plotting many populations, \code{layout} should be set 
  appropriately, and it may be useful to plot to, e.g., a \code{pdf} device.
}
\examples{
mp <- system.file('example.mp', package='mptools')
met <- meta(mp)

# Subset of populations
knt(met, pops=c('Pop 169', 'Pop 170', 'Pop 174', 'Pop 175'), 
    kch(met, dirname(mp)), show_N=TRUE, results=results(mp),
    layout=c(2, 2), samelims=TRUE)
}

