\name{plot_uncond}
\alias{plot_uncond}
\title{Plot unconditional detection function from distance sampling model}
\usage{
plot_uncond(model, obs, xmat, gxvalues, nc, finebr, breaks, showpoints,
  showlines, maintitle, ylim, return.lines = FALSE, angle = -45,
  density = 20, col = "black", jitter = NULL, xlab = "Distance",
  ylab = "Detection probability", subtitle = TRUE, ...)
}
\arguments{
  \item{model}{fitted model from \code{ddf}}

  \item{obs}{value of observer for plot}

  \item{xmat}{processed data}

  \item{gxvalues}{detection function values for each
  observation}

  \item{nc}{number of equal-width bins for histogram}

  \item{finebr}{fine break values over which line is
  averaged}

  \item{breaks}{user define breakpoints}

  \item{showpoints}{logical variable; if TRUE plots
  predicted value for each observation}

  \item{showlines}{logical variable; if TRUE plots average
  predicted value line}

  \item{maintitle}{main title line for each plot}

  \item{ylim}{range of y axis; defaults to (0,1)}

  \item{return.lines}{if TRUE, returns values for line}

  \item{angle}{shading angle for hatching}

  \item{density}{shading density for hatching}

  \item{col}{plotting colour}

  \item{jitter}{scaling option for plotting points.  Jitter
  is applied to points by multiplying the fitted value by a
  random draw from a normal distribution with mean 1 and sd
  jitter.}

  \item{xlab}{label for x-axis}

  \item{ylab}{label for y-axis}

  \item{subtitle}{if TRUE, shows plot type as sub-title}

  \item{\dots}{other graphical parameters, passed to the
  plotting functions (\code{plot}, \code{hist},
  \code{lines}, \code{points}, etc)}
}
\value{
if \code{return.lines==TRUE} returns dataframe
\code{average.line} otherwise just plots
}
\description{
Plots unconditional detection function for observer=obs
observations overlays histrogram, average detection
function and values for individual observations data.
Internal function called by \code{plot} methods.
}
\author{
Jeff Laake, Jon Bishop, David Borchers
}
\keyword{plot}

