% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis_setting.R
\name{chart_ax_x}
\alias{chart_ax_x}
\alias{chart_ax_y}
\alias{chart_ax_x.ms_chart}
\alias{chart_ax_y.ms_chart}
\title{axis settings}
\usage{
chart_ax_x(x, orientation, crosses, cross_between, major_tick_mark,
  minor_tick_mark, tick_label_pos, display, num_fmt, rotation, limit_min,
  limit_max, position, second_axis = FALSE)

chart_ax_y(x, orientation, crosses, cross_between, major_tick_mark,
  minor_tick_mark, tick_label_pos, display, num_fmt, rotation, limit_min,
  limit_max, position, second_axis = FALSE)

\method{chart_ax_x}{ms_chart}(x, orientation, crosses, cross_between,
  major_tick_mark, minor_tick_mark, tick_label_pos, display, num_fmt, rotation,
  limit_min, limit_max, position, second_axis = FALSE)

\method{chart_ax_y}{ms_chart}(x, orientation, crosses, cross_between,
  major_tick_mark, minor_tick_mark, tick_label_pos, display, num_fmt, rotation,
  limit_min, limit_max, position, second_axis = FALSE)
}
\arguments{
\item{x}{an \code{ms_chart} object.}

\item{orientation}{axis orientation, one of 'maxMin', 'minMax'.}

\item{crosses}{specifies how the axis crosses the perpendicular
axis, one of 'autoZero', 'max', 'min'.}

\item{cross_between}{specifies how the value axis crosses the
category axis between categories, one of 'between', 'midCat'.}

\item{major_tick_mark, minor_tick_mark}{tick marks position,
one of 'cross', 'in', 'none', 'out'.}

\item{tick_label_pos}{ticks labels position, one of 'high',
'low', 'nextTo', 'none'.}

\item{display}{should the axis be displayed (a logical of
length 1).}

\item{num_fmt}{number formatting. See section for more details.}

\item{rotation}{rotation angle. Value should be between `-360`
and `360`.}

\item{limit_min}{minimum value on the axis.}

\item{limit_max}{maximum value on the axis.}

\item{position}{position value that cross the other axis.}

\item{second_axis}{unused}
}
\description{
Define settings for an x or y axis.
}
\section{Methods (by class)}{
\itemize{
\item \code{ms_chart}: chart_ax_x method for ms_chart objects

\item \code{ms_chart}: chart_ax_y method for ms_chart objects
}}

\section{num_fmt}{

All \code{\%} need to be doubled, \code{0\%\%} mean "a number
and percent symbol".

From my actual knowledge, depending on some chart type
and options, the following values are not systematically
used by office chart engine; i.e. when chart pre-compute
percentages, it seems using \code{0\%\%} will have no
effect.

\itemize{
  \item General: default value
  \item 0: display the number with no decimal
  \item 0.00: display the number with two decimals
  \item 0\%\%: display as percentages
  \item 0.00\%\%: display as percentages with two digits
  \item #,##0
  \item #,##0.00
  \item 0.00E+00
  \item # ?/?
  \item # ??/??
  \item mm-dd-yy
  \item d-mmm-yy
  \item d-mmm
  \item mmm-yy
  \item h:mm AM/PM
  \item h:mm:ss AM/PM
  \item h:mm
  \item h:mm:ss
  \item m/d/yy h:mm
  \item #,##0 ;(#,##0)
  \item #,##0 ;[Red](#,##0)
  \item #,##0.00;(#,##0.00)
  \item #,##0.00;[Red](#,##0.00)
  \item mm:ss
  \item [h]:mm:ss
  \item mmss.0
  \item ##0.0E+0
  \item @
}
}

