\name{predict.msgl}
\alias{predict.msgl}
\title{Predict}
\usage{
  \method{predict}{msgl} (object, x,
    sparse.data = is(x, "sparseMatrix"), ...)
}
\arguments{
  \item{object}{an object of class msgl, produced with
  \code{msgl}.}

  \item{x}{a data matrix of size \eqn{N_\textrm{new} \times
  p}.}

  \item{sparse.data}{if TRUE \code{x} will be treated as
  sparse, if \code{x} is a sparse matrix it will be treated
  as sparse by default.}

  \item{...}{ignored.}
}
\value{
  \item{link}{the linear predictors -- a list of length
  \code{length(fit$beta)} one item for each model, with
  each item a matrix of size \eqn{K \times N_\textrm{new}}
  containing the linear predictors.} \item{response}{the
  estimated probabilities -- a list of length
  \code{length(fit$beta)} one item for each model, with
  each item a matrix of size \eqn{K \times N_\textrm{new}}
  containing the probabilities.} \item{classes}{the
  estimated classes -- a matrix of size \eqn{N_\textrm{new}
  \times d} with \eqn{d=}\code{length(fit$beta)}.}
}
\description{
  Computes the linear predictors, the estimated
  probabilities and the estimated classes for a new data
  set.
}
\examples{
data(SimData)

x.1 <- sim.data$x[1:50,]
x.2 <- sim.data$x[51:100,]

classes.1 <- sim.data$classes[1:50]
classes.2 <- sim.data$classes[51:100]

lambda <- msgl.lambda.seq(x.1, classes.1, alpha = .5, d = 50, lambda.min = 0.05)
fit <- msgl(x.1, classes.1, alpha = .5, lambda = lambda)

# Predict classes of new data set x.2
res <- predict(fit, x.2)

# The error rates of the models
Err(res, classes = classes.2)

# The predicted classes for model 20
res$classes[,20]
}
\author{
  Martin Vincent
}

