% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_message_distances.R
\name{get_message_distances}
\alias{get_message_distances}
\title{Compare message distance}
\usage{
get_message_distances(pkg = ".")
}
\arguments{
\item{pkg}{The directory of an R package to extract diagnostic messages from. Path is passed to \code{\link[devtools]{as.package}}.}
}
\value{
A \dQuote{tibble} (data frame) containing messages, pluralized messages, and the file location of each message.
}
\description{
Compare the string distance of messages to check for near-duplicates
}
\details{
Compares the generalized Levenshtein (edit) distance between pairs of messages using \code{\link[utils]{adist}}, returning the data frame of messages from \code{\link{get_messages}} with additional columns corresponding to the pairwise distance
}
\examples{
pkg <- dummy_pkg()

# get message distances
dist <- get_message_distances(pkg = pkg)
}
\author{
Thomas J. Leeper
}
\seealso{
\code{\link{get_messages}}, \code{\link{spell_check_msgs}}
}

