\name{simulated HCV data}
\alias{sim1}
\alias{sim2}
\alias{sim3}
\docType{data}
\title{ HCV Progression after liver transplant}
\description{
  Simulated data for individuals with liver transplants, giving
  covariates, time since transplant, and observed liver state.  Cases
  generally have repeated biopsies.
}

\format{
  A data frame.  \code{sim1} has 21 cases with 46 observations;
  \code{sim2} has 335 cases with 789 records, and \code{sim3} has 1,340
  cases with 3,356 records.  
  \describe{
    \item{\code{id}}{The patient id.}
    \item{\code{fib}}{Fibrosis state from 1 through 5, using the Metavir
      scale (see the reference by Bedosa et al.  We actually use the
      Metavir value +1 because the algorithm expects 1 as the first
      state, not 0.).  1 means a
      healthy liver, with higher numbers representing increasing liver
      damage.  5 means cirrhosis.}
    \item{\code{time}}{Years since transplant.}
    \item{\code{k}}{(\code{sim1} only) Standard Normal covariate
    intended to vary between cases but not across time within a case.
    The intention was not realized: it variest within cases as well.}
    \item{\code{x1}}{(\code{sim1} only) Standard Normal covariate, drawn
      independently for each time of each case.}
    \item{\code{C1}}{(\code{sim2} and \code{sim3}) Normally distributed
  continuous variable.}
    \item{\code{C2}}{(\code{sim2} and \code{sim3}) Exponentially
  distributed continuous variable.}
    \item{\code{D3}}{(\code{sim2} and \code{sim3}) binary variable}
    \item{\code{C4}}{(\code{sim2} and \code{sim3}) age, from a uniform
  initial age and time of observation.}
    \item{\code{K5}}{(\code{sim2} and \code{sim3}) Normally distributed
  continuous variable, constant within case.}
    \item{\code{K6}}{(\code{sim2} and \code{sim3}) Binary variable,
  constant within case.}
  }
}
\details{
  The datasets include a time 0 observation of fibrosis stage 1
  (uninfected) for each case.  Note the times are time of
  observation, \emph{not} time of entry into a state.  Fibrosis is
  observed with error; errors are likely to produce a reading lower than
  the actual score.
  

  As required by \code{mspath}, observations are sorted by id and then
  time.
  
  It is unusual to know the exact time of infection and have repeated
  observations per case.  We were interested in a study of transplant
  patients that had both features.


  The observed fibrosis stage was generated by simulating the
  \code{mspath} model, using \code{do.what=10}.  As an example, after
  generating the cases, covariates and observation times for \code{sim1}
  the outcomes came from
  \preformatted{
data(q2, e2, sim1)
cons1 <- list(k=c(1, 1, 2, 2), x1=rep(3, 4))
init1 <- c(seq(-1, by=.2, length=4),# intercepts
              0.5, 0.8, #k
              -1.0, # x1
              -0.5, .7, # history
              .2, .05 # misclassification
           )

r <- mspath(fib~time, q2, misc=SIMPLE, e2,
            inits=init1,
            subject=id,
            covariates=~k+x1,
            constraint=cons1,
            econstraint=c(1, 2, 1, 2, 1),
            pathvars=c("LN(TSO)", "TIS"),
            pathoffset=0.5,
            pathconstraint=list("LN(TSO)"=rep(1, 4), "TIS"=rep(2, 4)),
            data=sim1,
            isexact=TRUE,
            fixedpars=seq(along=init1),
            stepnumerator=1,
            stepdenominator=1,
            do.what=10)
	  }
	  The final \code{sim1} was extracted from the return value \code{r}.

}
\source{
  See the reference by Berenguer et al. for a published study using a
  dataset in the same format as this simulated one.  That study did not
  use multi-state path methods.
}
\references{
  Bedosa P, Pynard T. An algorithm for the grading of activity in
  chronic hepatitis C. The METAVIR Cooperative Study Group.  Hepatology
  1996. 24:289-93.
  
  Berenguer M, Ferrell L, Watson J, et al.  HCV-related fibrosis
  progression following liver transplantation: increase in recent
  years. \emph{J Hepatology}, 32:673-84, 2000.
}
\examples{
library(mspath)
data(q2, e2, sim2)
 r <- mspath(fib~time, misc=TRUE, ematrix=e2, qmatrix=q2, inits=rep(.5, 9), subject=id,
             data=sim2, stepnumerator=1, stepdenominator=1, initprobs=c(1.0, 0, 0, 0, 0),
             do.what=0)
}
\keyword{datasets}
