% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mtar.R
\docType{data}
\name{returns}
\alias{returns}
\title{Returns of the closing prices of three financial indexes}
\format{
A data frame with 1505 rows and 4 variables:
\describe{
  \item{Date}{a vector indicating the dates of the measurements.}
  \item{COLCAP}{a numeric vector indicating the returns of COLCAP.}
  \item{SP500}{a numeric vector indicating the returns of SP500.}
  \item{BOVESPA}{a numeric vector indicating the returns of BOVESPA.}
}
}
\usage{
data(returns)
}
\description{
These data correspond to the returns of closing prices of the
Colcap, Bovespa, and S&P 500 indexes from 2010-02-01 to 2016-03-31 (1505 time
points). Colcap is a leading indicator of the price dynamics of the 20 most
liquid shares on the Colombian Stock Market. Bovespa is the Brazilian stock
market index, the world's thirteenth largest and most important stock exchange,
and the first in Latin America. Finally, the Standard & Poor's 500 (S&P 500)
index is a stock index based on the 500 largest companies in the United States.
}
\examples{
data(returns)
dev.new()
plot(ts(as.matrix(returns[,-1])), main="Returns")

}
\references{
Romero, L.V. and Calderon, S.A. (2021) Bayesian estimation of a multivariate TAR model when the noise
            process follows a Student-t distribution. Communications in Statistics - Theory and Methods, 50, 2508-2530.
}
\keyword{datasets}
