% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mtscr_prepare.R
\name{mtscr_prepare}
\alias{mtscr_prepare}
\title{Prepare database for MTS}
\usage{
mtscr_prepare(
  df,
  id_column,
  item_column = NULL,
  score_column,
  top = 1,
  minimal = FALSE,
  ties_method = c("random", "average"),
  normalise = TRUE,
  self_ranking = NULL
)
}
\arguments{
\item{df}{Data frame in long format.}

\item{id_column}{Name of the column containing participants' id.}

\item{item_column}{Optional, name of the column containing distinct trials
(e.g. names of items in AUT).}

\item{score_column}{Name of the column containing divergent thinking scores
(e.g. semantic distance).}

\item{top}{Integer or vector of integers (see examples), number of top answers
to prepare indicators for. Default is 1, i.e. only the top answer.}

\item{minimal}{Logical, append columns to df (\code{FALSE}) or return only \code{id}, \code{item},
and the new columns (\code{TRUE}).}

\item{ties_method}{Character string specifying how ties are treated when
ordering. Can be \code{"average"} (better for continuous scores like semantic
distance) or \code{"random"} (default, better for ratings). See \code{\link[=rank]{rank()}} for details.}

\item{normalise}{Logical, should the creativity score be normalised? Default is \code{TRUE} and
it's recommended to leave it as such.}

\item{self_ranking}{Name of the column containing answers' self-ranking.
Provide if model should be based on top answers self-chosen by the participant.
Every item should have its own ranks. The top answers should have a value of 1,
and the other answers should have a value of 0. In that case, the \code{top} argument
doesn't change anything and should be left as \code{top = 1}. \code{ties_method} is not used if \code{self_ranking}
was provided. See \link{mtscr_self_rank} for example.}
}
\value{
The input data frame with additional columns:
\describe{
\item{\code{.z_score}}{Numerical, z-score of the creativity score}
\item{\code{.ordering}}{Numerical, ranking of the answer relative to participant and item}
\item{\code{.ordering_topX}}{Numerical, 0 for \emph{X} top answers, otherwise value of \code{.ordering}}
}
Number of \code{.ordering_topX} columns depends on the \code{top} argument. If \code{minimal = TRUE},
only the new columns and the item and id columns are returned. The values are
relative to the participant AND item, so the values for different
participants scored for different tasks (e.g. uses for "brick" and "can") are distinct.
}
\description{
Prepare database for MTS analysis.
}
\examples{
data("mtscr_creativity", package = "mtscr")
# Indicators for top 1 and top 2 answers
mtscr_prepare(mtscr_creativity, id, item, SemDis_MEAN, top = 1:2, minimal = TRUE)
}
