% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{long_ggplot}
\alias{long_ggplot}
\alias{long_plot}
\alias{long_plot_base}
\title{Smart plotting of parameter-long data frames}
\usage{
long_ggplot(.data, ..., max_facets = 9, facet_args = list())

long_plot(.data, id_vars = NULL, measure_var = "value", x = NULL,
  y = NULL, facets = NULL, geom = "path", error_var = NULL, ...,
  max_facets = 9, facet_args = list(), scales = list())

long_plot_base(.data, id_vars = NULL, measure_var = "value",
  x = NULL, y = NULL, facets = NULL, geom = "path",
  error_var = NULL, ...)
}
\arguments{
\item{.data}{A \code{data.frame}}

\item{...}{Additional aesthetic mappings, passed on to
(or treated similarly to) \link[ggplot2:aes_string]{aes_string}}

\item{max_facets}{Constrain the maximum number of facets, where available}

\item{facet_args}{Passed on to \link[ggplot2:facet_wrap]{facet_wrap}}

\item{id_vars}{Columns that identify unique rows}

\item{measure_var}{Column that contains values to be plotted}

\item{x}{Column to be used on the x-axis}

\item{y}{Column to be used on the y-axis}

\item{facets}{Column(s) to be used as facetting variable (using \link[ggplot2:facet_wrap]{facet_wrap})}

\item{geom}{Can be any combination of point, path, or line.}

\item{error_var}{The column to be used for plus/minus error bars}

\item{scales}{Customize aesthetic mapping in long_plot()}
}
\description{
These functions are intended to quickly visualize plot a parameter-long
data frame with a few variables that identify single rows in the value column. The function
is optimised to plot data with a time axis data either horizontally
(time on the x axis) or vertically (time on the y axis). Facets are intended
to be by parameter, which is guessed based on the right-most discrete variable named
in id_vars. In the context of a \link{mudata} object, this function almost always
guesses the axes correctly, but these choices can be overridden.
}
\examples{
library(tidyr)
library(dplyr)
pocmaj_long <- pocmajsum \%>\%
  select(core, depth, Ca, Ti, V) \%>\%
  gather(Ca, Ti, V, key = "variable", value = "value")
long_plot(pocmaj_long, col="core")
long_ggplot(pocmaj_long, col="core")

}
