% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unitCube_floor.R
\docType{class}
\name{unitCube_floor-class}
\alias{unitCube_floor-class}
\alias{unitCube_floor}
\title{An S4 class to represent the function \eqn{\lfloor x_1 + \ldots + x_n \rfloor} on \eqn{[0,1]^n}}
\description{
Implementation of the function
\deqn{f \colon [0,1]^n \to [0,n],\, \vec{x} \mapsto f(\vec{x}) = \lfloor x_1 + \ldots + x_n \rfloor,}
where \eqn{n \in \{1,2,3,\ldots\}} is the dimension of the integration domain \eqn{C_n = [0,1]^n}.
The integral is known to be
\deqn{\int_{C_n} f(\vec{x}) d\vec{x} = \frac{n-1}{2}.}
}
\details{
The instance needs to be created with one parameter representing the dimension \eqn{n}.
}
\section{Slots}{

\describe{
\item{\code{dim}}{An integer that captures the dimension}
}}

\examples{
n <- as.integer(3)
f <- new("unitCube_floor",dim=n)
}
