% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unsupervised.R
\name{mfa}
\alias{mfa}
\title{Multiple Factor Analysis - MFA}
\usage{
mfa(X, type = rep("c", length(X)), graph = FALSE, ...)
}
\arguments{
\item{X}{\code{list} of input blocks.}

\item{type}{\code{character} vector indicating block types, defaults to \code{rep("c", length(X))} for continuous values.}

\item{graph}{\code{logical} indicating if decomposition should be plotted.}

\item{...}{additional arguments for RGCCA approach.}
}
\value{
\code{multiblock} object including relevant scores and loadings. Relevant plotting functions: \code{\link{multiblock_plots}}
and result functions: \code{\link{multiblock_results}}.
}
\description{
This is a wrapper for the \code{FactoMineR::MFA} function for computing MFA.
}
\details{
MFA is a methods typically used to compare several equally sized matrices. It is
often used in sensory analyses, where matrices consist of sensory characteristics and products,
and each assessor generates one matrix each. In its basic form, MFA scales all matrices by their
largest eigenvalue, concatenates them and performs PCA on the result. There are several
possibilities for plots and inspections of the model, handling of categorical and continuous
inputs etc. connected to MFA.
}
\examples{
data(potato)
potList <- as.list(potato[c(1,2,9)])
pot.mfa    <- mfa(potList)
if(interactive()){
  plot(pot.mfa$MFA)
}

}
\references{
Pagès, J. (2005). Collection and analysis of perceived product inter-distances using multiple factor analysis: Application to the study of 10 white wines from the Loire valley. Food Quality and Preference, 16(7), 642–649.
}
\seealso{
Overviews of available methods, \code{\link{multiblock}}, and methods organised by main structure: \code{\link{basic}}, \code{\link{unsupervised}}, \code{\link{asca}}, \code{\link{supervised}} and \code{\link{complex}}.
Common functions for computation and extraction of results and plotting are found in \code{\link{multiblock_results}} and \code{\link{multiblock_plots}}, respectively.
}
