\name{sort_genes_RF}
\alias{sort_genes_RF}
\title{
Sort genes/features for pair-based random forest classifier downstream steps
}
\description{
\code{sort_genes_RF} uses random forest to sort genes/features prior of downstream steps such as gene pairs/rules selection which will involve random forest models.
}
\usage{
sort_genes_RF(data_object,
             featureNo_altogether,
             featureNo_one_vs_rest,
             rank_data = FALSE,
             platform_wise = FALSE,
             num.trees = 500,
             min.node.size = 1,
             importance = "impurity",
             write.forest = FALSE,
             keep.inbag = FALSE,
             verbose = TRUE, ...)
}
\arguments{
  \item{data_object}{
data object generated by ReadData function. Object contains the data and labels.
}

  \item{featureNo_altogether}{
an integer. Optional. Indicating specific number of top sorted genes to be returned from one random forest model contains all the labels together. If 0 then this sorting will be skipped. By default, if no number is specified then all available genes will be sorted and returned because user can specify how many top genes will be used in the downstream analysis.
}
  \item{featureNo_one_vs_rest}{
an integer. Optional. Indicating specific number of top sorted genes to be returned from 'one vs rest' random forest models. This means each class will have a random forest where the samples from the other classes will be labels as 'rest'. If 0 then this sorting will be skipped. By default, if no number is specified then all available genes will be sorted and returned because user can specify how many top genes will be used in the downstream analysis.
}
\item{rank_data}{
  logical indicates if the data should be ranked (features will be ranked inside each sample). Default is FALSE.
  }
  \item{platform_wise}{
logical indicates if the gene importance should be calculated in each platform seperatly then combined based on the lowest importance value (i.e. a gene with low importance in any platform will not be prioritized). Default is FALSE. see details for more description.
}
  \item{num.trees}{
an integer. Number of trees. Default is 500. It is recommended to increase num.trees in case of having large number of features (ranger function argument).
}
  \item{min.node.size}{
an integer. Minimal node size. Default is 1. (ranger function argument)
}
  \item{importance}{
Variable importance mode, should be one of 'impurity', 'impurity_corrected', 'permutation'.
Defualt is 'impurity' (ranger function argument)
}
  \item{write.forest}{
Save ranger.forest object, required for prediction. Default is FALSE to reduce memory. (ranger function argument)
}
  \item{keep.inbag}{
Save how often observations are in-bag in each tree. Default is FALSE. (ranger function argument)
}
  \item{verbose}{
a logical value indicating whether processing messages will be printed or not. Default is TRUE.
}
  \item{\dots}{
any additional arguments to be passed to ranger function (i.e. random forest function) in ranger package. For example, seed for reproducibility.
}
}
\details{
For platform-wise option. When platform_wise=TRUE, for example, if data has three platforms (i.e. P1, P2, and P3), and random forest was performed for class 1 (C1) versus rest in each platform seperatly, then C1 will have 3 importance lists contain the genes sorted based on P1-P3, genes will be sorted and ranked in each list (lower rank number means higher importance), the combined final sorting will be determined by the lowest importance level in the lists, it means a gene with (5,5,5) will be prioritized over a gene with (1,1,6). And this is applied on the altogether sorting and one-vs-rest sorting. Other combining methods could be added in the future.
}
\value{
returns RandomForest_sorted_genes object which contains sorted genes based on the importance in each class (one-vs-rest) sorting and based altogether sorting. Also it contains the random forest objects those used in the sorting.
}

\author{
Nour-al-dain Marzouka <nour-al-dain.marzouka at med.lu.se>
}
\examples{
# generate random data
Data <- matrix(runif(100000), nrow=100, ncol=100,
               dimnames = list(paste0("G",1:100), paste0("S",1:100)))

# generate random labels
L <- sample(x = c("A","B","C"), size = 100, replace = TRUE)

# generate random platform labels
P <- sample(c("P1","P2"), size = 100, replace = TRUE)

table(P,L)

# create data object
object <- ReadData(Data = Data,
                   Labels = L,
                   Platform = P, verbose = FALSE)

# sort genes
genes_RF <- sort_genes_RF(data_object = object,
                           seed=123456, verbose = FALSE)
genes_RF

# not to run
# creat and sort rules
# rules_RF <- sort_rules_RF(data_object = object,
#                           sorted_genes_RF = genes_RF,
#                           genes_altogether = 10,
#                           genes_one_vs_rest = 10,
#                           seed=123456, verbose = FALSE)
#
# # train the final model
# RF_classifier <- train_RF(data_object = object,
#                           sorted_rules_RF = rules_RF, verbose = FALSE)
#
# # predict
# results <- predict_RF(classifier = RF_classifier,
#                       Data = object)
# results
#
# round(table(results$predictions, object$data$Labels))
}
