% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D_regularized_fold.R
\name{D_regularized_fold}
\alias{D_regularized_fold}
\title{Use manually defined data folds for regularization and obtain estimates for each separately.}
\usage{
D_regularized_fold(
  data,
  mv.vars,
  group.var,
  group.values,
  alpha = 0.5,
  s = "lambda.min",
  type.measure = "deviance",
  rename.output = TRUE,
  fold.var
)
}
\arguments{
\item{data}{A data frame.}

\item{mv.vars}{Character vector. Variable names in the multivariate variable set.}

\item{group.var}{The name of the group variable.}

\item{group.values}{Vector of length 2, group values (e.g. c("male", "female) or c(0,1)).}

\item{alpha}{Alpha-value for penalizing function ranging from 0 to 1: 0 = ridge regression, 1 = lasso, 0.5 = elastic net (default).}

\item{s}{Which lambda value is used for predicted values? Either "lambda.min" (default) or "lambda.1se".}

\item{type.measure}{Which measure is used during cross-validation. Default "deviance".}

\item{rename.output}{Logical. Should the output values be renamed according to the group.values? Default TRUE.}

\item{fold.var}{Character string. Name of the fold variable.}
}
\value{
\item{D}{Multivariate descriptive statistics and differences.}
\item{pred.dat}{A data.frame with predicted values.}
\item{cv.mod}{Regularized regression model from cv.glmnet.}
}
\description{
Use manually defined data folds for regularization and obtain estimates for each separately.
}
\examples{
set.seed(34246)
n1 <- 100
n2 <- 10
d <-
  data.frame(
    sex = sample(c("male", "female"), n1 * n2, replace = TRUE),
    fold = sample(x = LETTERS[1:n2], size = n1 * n2, replace = TRUE),
    x1 = rnorm(n1 * n2),
    x2 = rnorm(n1 * n2),
    x3 = rnorm(n1 * n2)
  )

D_regularized_fold(
  data = d,
  mv.vars = c("x1", "x2", "x3"),
  group.var = "sex",
  group.values = c("female", "male"),
  fold.var = "fold"
)$D
}
\seealso{
\code{\link[glmnet]{cv.glmnet}}
}
