% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D_regularized_vanilla.R
\name{D_regularized_vanilla}
\alias{D_regularized_vanilla}
\title{Use same data partition for regularization and estimation.}
\usage{
D_regularized_vanilla(
  data,
  mv.vars,
  group.var,
  group.values,
  alpha = 0.5,
  nfolds = 10,
  s = "lambda.min",
  type.measure = "deviance",
  rename.output = TRUE,
  append.data = FALSE
)
}
\arguments{
\item{data}{A data frame.}

\item{mv.vars}{Character vector. Variable names in the multivariate variable set.}

\item{group.var}{The name of the group variable.}

\item{group.values}{Vector of length 2, group values (e.g. c("male", "female) or c(0,1)).}

\item{alpha}{Alpha-value for penalizing function ranging from 0 to 1: 0 = ridge regression, 1 = lasso, 0.5 = elastic net (default).}

\item{nfolds}{Number of folds used for obtaining lambda (range from 3 to n-1, default 10).}

\item{s}{Which lambda value is used for predicted values? Either "lambda.min" (default) or "lambda.1se".}

\item{type.measure}{Which measure is used during cross-validation. Default "deviance".}

\item{rename.output}{Logical. Should the output values be renamed according to the group.values? Default TRUE.}

\item{append.data}{Logical. If TRUE, the original data is appended to the predicted variables.}
}
\value{
\item{D}{Multivariate descriptive statistics and differences.}
\item{pred.dat}{A data.frame with predicted values.}
\item{cv.mod}{Regularized regression model from cv.glmnet.}
}
\description{
Use same data partition for regularization and estimation.
}
\examples{
D_regularized(
  data = iris[iris$Species == "setosa" | iris$Species == "versicolor", ],
  mv.vars = c("Sepal.Length", "Sepal.Width", "Petal.Length", "Petal.Width"),
  group.var = "Species", group.values = c("setosa", "versicolor")
)$D
}
\seealso{
\code{\link[glmnet]{cv.glmnet}}
}
