\name{DCCSWA}
\alias{DCCSWA}
\title{Dual Common Component and Specific Weights Analysis}
\usage{
DCCSWA(Data, Group, ncomp = NULL, Scale = FALSE, graph = FALSE)
}
\arguments{
  \item{Data}{a numeric matrix or data frame}

  \item{Group}{a vector of factors associated with group
  structure}

  \item{ncomp}{number of components, if NULL number of
  components is equal to 2}

  \item{Scale}{scaling variables, by defalt is False. By
  default data are centered within groups.}

  \item{graph}{should loading and component be plotted}
}
\value{
list with the following results:

\item{Data}{original data}

\item{Con.Data}{Concatenated centered data}

\item{split.Data}{Group centered data}

\item{Group}{Group as a factor vector}

\item{loadings.common}{Matrix of common loadings}

\item{saliences}{each group having a specific contribution
to the determination of this common space, namely the
salience, for each dimension under study}

\item{lambda}{The specific variances of group}

\item{exp.var}{Percentages of total variance recovered
associated with each dimension}
}
\description{
Dual Common Component and Specific Weights Analysis: to
find common structure among variables of different groups
}
\examples{
Data = iris[,-5]
Group = iris[,5]
res.DCCSWA = DCCSWA(Data, Group, graph=TRUE)
loadingsplot(res.DCCSWA, axes=c(1,2))
scoreplot(res.DCCSWA, axes=c(1,2))
}
\references{
E. M. Qannari, P. Courcoux, and E. Vigneau (2001). Common
components and specific weights analysis performed on
preference data. \emph{Food Quality and Preference},
12(5-7), 365-368.
}
\seealso{
\code{\link{mgPCA}}, \code{\link{FCPCA}},
\code{\link{BGC}}, \code{\link{DSTATIS}},
\code{\link{DGPA}}, \code{\link{summarize}},
\code{\link{TBWvariance}}, \code{\link{loadingsplot}},
\code{\link{scoreplot}}, \code{\link{iris}}
}

