% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multimark_functions.R
\docType{class}
\name{multimarkSCRsetup-class}
\alias{multimarkSCRsetup-class}
\title{Class \code{"multimarkSCRsetup"}}
\description{
A class of spatial 'mulitmark' model inputs
}
\section{Slots}{

\describe{
\item{\code{Enc.Mat}}{Object of class \code{"matrix"}. The observed encounter histories (with rows corresponding to individuals and columns corresponding to sampling occasions).}

\item{\code{data.type}}{Object of class \code{"character"}. The encounter history data type ("never", "sometimes", or "always").}

\item{\code{vAll.hists}}{Object of class \code{"integer"}. An ordered vector containing all possible encounter histories in sequence.}

\item{\code{Aprime}}{Object of class \code{"sparseMatrix"}. Transpose of the A matrix mapping latent encounter histories to observed histories.}

\item{\code{indBasis}}{Object of class \code{"numeric"}.An ordered vector of the indices of the three encounter histories updated by each basis vector.}

\item{\code{ncolbasis}}{Object of class \code{"integer"}. The number of needed basis vectors.}

\item{\code{knownx}}{Object of class \code{"integer"}. Frequencies of known encounter histories.}

\item{\code{C}}{Object of class \code{"integer"}. Sampling occasion of first capture for each encounter history.}

\item{\code{L}}{Object of class \code{"integer"}. Sampling occasion of last capture for each encounter history.}

\item{\code{naivex}}{Object of class \code{"integer"}. ``Naive'' latent history frequencies assuming a one-to-one mapping with \code{Enc.Mat}.}

\item{\code{covs}}{Object of class \code{"data.frame"}. Temporal covariates for detection probability (the number of rows in the data frame must equal the number of sampling occasions).}

\item{\code{spatialInputs}}{Object of class \code{"list"}. List is of length 4 containing \code{trapCoords} and \code{studyArea} after re-scaling coordinates based on \code{maxscale}, as well as the original (not re-scaled) grid cell resolution (\code{origCellRes}) and re-scaling range (\code{Srange}).}
}}

\section{Objects from the Class}{

Objects can be created by calls of the form \code{processdata(Enc.Mat, ...)} or \code{new("multimarkSCRsetup", ...)}.
}

\section{Methods}{

No methods defined with class "multimarkSCRsetup".
}

\examples{
showClass("multimarkSCRsetup")
}
\seealso{
\code{\link{processdataSCR}}
}
\author{
Brett T. McClintock
}
\keyword{classes}
