% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform_Ab_V.R
\name{V_to_Ab}
\alias{V_to_Ab}
\alias{Ab_to_V}
\title{Transform Vertex/Inequality Representation of Polytope}
\usage{
V_to_Ab(V)

Ab_to_V(A, b, options = 2)
}
\arguments{
\item{V}{a matrix with one vertex of a polytope per row
(e.g., the admissible preference orders of a random utility model or any other theory).
Since the values have to sum up to one within each multinomial condition,
the last value of each multinomial is omitted
(e.g., the prediction 1-0-0/0-1 for a tri and binomial becomes 1-0/0).}

\item{A}{a matrix defining the convex polytope via \code{A*x <= b}.
The columns of \code{A} do not include the last choice option per item type and
thus the number of columns must be equal to \code{sum(options-1)}
(e.g., the column order of \code{A} for \code{k = c(a1,a2,a2, b1,b2)}
is \code{c(a1,a2, b1)}).}

\item{b}{a vector of the same length as the number of rows of \code{A}.}

\item{options}{number of choice options per item type.
Can be a vector \code{options=c(2,3,4)} if item types have 2/3/4 choice options.}
}
\description{
For convex polytopes: Requires \code{rPorta} (\url{https://github.com/TasCL/rPorta})
to transform the vertex representation to/from the inequality representation.
}
\details{
Choice models can be represented as polytopes if they assume a latent
mixture over a finite number preference patterns (random preference model).
For the general approach and theory underlying binary and ternary choice models,
see Regenwetter et al. (2012, 2014, 2017).

Note that the transformation can be very slow and might require days or months
of computing or not converge at all!

For binary choices (\code{options=2}), additional constraints are added to \code{A} and \code{b}
to ensure that all dimensions of the polytope satisfy:  0 <= p_i <= 1.
For ternary choices (\code{options=3}), constraints are added to ensure that 0 <= p_1+p_2 <=1
for pairwise columns (1+2, 3+4, 5+6, ...). See \code{\link{Ab_multinom}}.
}
\examples{
\donttest{
######## (requires rPorta) ########

### binary choice:
# linear order: x1 < x2 < x3 < .50
# (cf. WADDprob in ?predict_multiattribute)
A <- matrix(c(1, -1,  0,
              0,  1, -1,
              0,  0,  1),
            ncol = 3, byrow = TRUE)
b <- c(0, 0, .50)
Ab_to_V(A, b)


### binary choice polytope:
# choice options: {prefer_a, prefer_b}
# column order of vertices: (ab, ac, bc)
# with:  ij = 1  <=>  utility(i) > utility(j)
V <- matrix(c(1, 1, 1,  # c < b < a
              1, 1, 0,  # b < c < a
              0, 1, 1,  # c < a < b
              0, 0, 1   # a < c < b
            ), ncol = 3, byrow = TRUE)
V_to_Ab(V)


### ternary choice (Regenwetter & Davis-Stober, 2012)
# choice options:  {prefer_a, indifferent, prefer_b}
# column order:    (ab,ba,  ac,ca,  bc,cb)
# with:            ij = 1  <=> utility(i) > utility(j)
V <- matrix(c(
  # strict weak orders
  0, 1, 0, 1, 0, 1,  # a < b < c
  1, 0, 0, 1, 0, 1,  # b < a < c
  0, 1, 0, 1, 1, 0,  # a < c < b
  0, 1, 1, 0, 1, 0,  # c < a < b
  1, 0, 1, 0, 1, 0,  # c < b < a
  1, 0, 1, 0, 0, 1,  # b < c < a

  0, 0, 0, 1, 0, 1,  # a ~ b < c
  0, 1, 0, 0, 1, 0,  # a ~ c < b
  1, 0, 1, 0, 0, 0,  # c ~ b < a
  0, 1, 0, 1, 0, 0,  # a < b ~ c
  1, 0, 0, 0, 0, 1,  # b < a ~ c
  0, 0, 1, 0, 1, 0,  # c < a ~ b

  0, 0, 0, 0, 0, 0   # a ~ b ~ c
), byrow = TRUE, ncol = 6)
V_to_Ab(V)
}
}
\references{
Regenwetter, M., & Davis-Stober, C. P. (2012). Behavioral variability of choices versus structural inconsistency of preferences. Psychological Review, 119(2), 408-416. \url{https://doi.org/10.1037/a0027372}

Regenwetter, M., Davis-Stober, C. P., Lim, S. H., Guo, Y., Popova, A., Zwilling, C., … Messner, W. (2014). QTest: Quantitative testing of theories of binary choice. Decision, 1(1), 2-34. \url{https://doi.org/10.1037/dec0000007}

Regenwetter, M., & Robinson, M. M. (2017). The construct–behavior gap in behavioral decision research: A challenge beyond replicability. Psychological Review, 124(5), 533-550. https://doi.org/10.1037/rev0000067
}
