%     The multitaper R package
%     Multitaper and spectral analysis package for R
%     Copyright (C) 2010 Karim Rahim 

%     This file is part of the multitaper package for R.

%     The multitaper package is free software: you can redistribute it and
%     /or modify
%     it under the terms of the GNU General Public License as published by
%     the Free Software Foundation, either version 2 of the License, or
%     any later version.

%     The multitaper package is distributed in the hope that it will be 
%     useful, but WITHOUT ANY WARRANTY; without even the implied warranty 
%     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%     GNU General Public License for more details.

%     You should have received a copy of the GNU General Public License
%     along with Foobar.  If not, see <http://www.gnu.org/licenses/>.

%     If you wish to report bugs please contact the author. 
%     karim.rahim@gmail.com
%     112 Jeffery Hall, Queen's University, Kingston Ontario
%     Canada, K7L 3N6

\name{plot.mtm}
\alias{plot.mtm}
\title{Compute and plot the multitaper spectrum estimate}
\description{
   Plots the multitaper spectral estimate and the multitaper F-test.
}
\usage{
plot.mtm(x, jackknife = FALSE, Ftest = FALSE, ftbase = 1.01, siglines = NULL, ...) 
}
\arguments{
  \item{x}{x an object of the class mtm generated by spec.mtm.}
  \item{jackknife}{jackknife Boolean variable indicating if jackknife
    confidence intervals should be plotted.}
  \item{Ftest}{Ftest Boolean variable indicating if the multitaper F-Test
    should be plotted instead of the spectrum}
  \item{ftbase}{ftbase lowest value to be plotted when the F-test is
    plotted. This means when Ftest = TRUE, min(ftestvalue, ftbase) is plotted.}
  \item{siglines}{siglines values of indicates if horizontal lines
    indicating significant values should be plotted on the Ftest. Not
    currently implemented leave value as NULL.}
  \item{...}{Arguments to be passed to methods, such as graphical
    parameters (see 'par').}
}
\references{
Thomson, D.J (1982)
Spectrum estimation and harmonic analysis. \emph{Proceedings of the IEEE}
Volume \bold{70}, number 9, pp. 1055--1096.

Percival, D.B. and Walden, A.T. (1993)
\emph{Spectral analysis for physical applications}
Cambridge University Press. 
}
\examples{
data(willamette)
resSpec <- spec.mtm(willamette, nw=4, k=8, Ftest=TRUE, plot=FALSE)
plot(resSpec)
plot(resSpec, Ftest=TRUE)

}
\keyword{multitaper}
