%     The multitaper R package
%     Multitaper and spectral analysis package for R
%     Copyright (C) 2013 Karim Rahim 
%
%     Written by Karim Rahim and Wesley Burr.
%
%     This file is part of the multitaper package for R.
%
%     The multitaper package is free software: you can redistribute it and
%     or modify it under the terms of the GNU General Public License as 
%     published by the Free Software Foundation, either version 2 of the 
%     License, or any later version.
%
%     The multitaper package is distributed in the hope that it will be 
%     useful, but WITHOUT ANY WARRANTY; without even the implied warranty 
%     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%     GNU General Public License for more details.
%
%     You should have received a copy of the GNU General Public License
%     along with multitaper.  If not, see <http://www.gnu.org/licenses/>.
%
%     If you wish to report bugs please contact the author. 
%     karim.rahim@gmail.com
%     112 Jeffery Hall, Queen's University, Kingston Ontario
%     Canada, K7L 3N6


\name{percivalAR4}
\alias{percivalAR4}
\title{Auto Regressive Series generated by Don Percival at Applied
  Physics Laboratory}
\description{This is a simulated AR(4) time series (page 45 of Percival
  and Walden 1993). The source of this series is: Applied Physics
  Laboratory (Don Percival). The value for delta T is 1, and the sample
  size is 1024. Another realization of this series based on the same
  autoregressive coefficients can be generated in R using the code in
  the example section of the documentation. 
}
\usage{percivalAR4}
\format{A time series object containing 1024 simulated values.}
\source{
  Presented on page 45 of Percival, D.B. and Walden, A.T. (1993).
  See: \url{http://faculty.washington.edu/dbp/DATA/ar4.dat}
}
\references{
Percival, D.B. and Walden, A.T. (1993)
\emph{Spectral analysis for physical applications.}
Cambridge University Press.
}
\examples{
## get the Percival realization of the series saved as data.
data(percivalAR4)
## generate another realization of this series using the same AR(4)
## coefficients.
ar4Coef <- c(2.7607, -3.8106, 2.6535, -0.9238)
ar4.ts <- arima.sim(list(order = c(4, 0, 0), ar=ar4Coef), n=1024)
}
\keyword{datasets}
