% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inside.R
\name{inside}
\alias{inside}
\title{Pass code into the multiverse}
\usage{
inside(multiverse, .expr, .label = NULL)
}
\arguments{
\item{multiverse}{A multiverse object. A multiverse object is an S3 object which can be defined using `multiverse()`}

\item{.expr}{R syntax. All the operations that the user wants to perform within the multiverse can be passed.
Since it accepts a single argument, chunks of code can be passed using `{}`. See example for details.}

\item{.label}{It is extracted automatically from the code block of type `multiverse`
when run in an RMarkdown document. This should be used only within an RMarkdown document. 
Defaults to NULL.}
}
\value{
a multiverse object
}
\description{
Add code to the multiverse using the function using a function call, or an assignment operator, which is
a wrapper around the function
}
\details{
The inside function can only access variables which can be accessed at the same environment 
where the multiverse object was declared in.

To perform a multiverse analysis, we will need to write code to be executed within the multiverse.
The `inside()` functions allows us to do this. Use `inside()` to pass any code to the specified multiverse,
which is captured as an expression. To define multiple analysis options in the code passed to the multiverse,
use the `branch()` function. See \code{\link{branch}} for more
details on how to declare multiple analysis options.

The `inside` function only stores the code, and does not execute any code at this step. To execute, we
provide separate functions. See \code{\link{execute}} for executing the code.

Instead of using the `inside()` function, an alternate implementation of the multiverse is using
the assignment operator, `<-`. See examples below.

**Note:** the `inside()` function can only access variables which can be accessed at the same level as the multiverse
object. Since `inside()` is merely an interface to add analysis to the multiverse object, even if it is being called 
by another function, it is actually manipulating the multiverse object, which will have a different parent environment
from where `inside()` is called, and hence not have access to variables which might be accessible in the environment 
within the function from where `inside()` is called.
}
\examples{
\donttest{
M.1 <- multiverse()

# using `inside` to declare multiverse code
inside(M.1, {
  data <- rnorm(100, 50, 20)

  x.mean <- mean(data, trim = branch(
    trim_values,
    "trim_none" ~ 0,
    "trim_1pc" ~ 0.05,
    "trim_5pc" ~ 0.025,
    "trim_10pc" ~ 0.05
  ))
})

M.2 <- multiverse()

# using the assignment operator to declare multiverse code
inside(M.2, {
    data <- rnorm(100, 50, 20)
}) 

inside(M.2, {
    mean <- mean(data, trim = branch(
    trim_values,
    "trim_none" ~ 0,
    "trim_1pc" ~ 0.05,
    "trim_5pc" ~ 0.025,
    "trim_10pc" ~ 0.05
  ))
})

# declaring multiple options for a data processing step (calculating a new variable)
data(durante)
df <- durante

inside(M.1, {
  df <- df  \%>\%
    mutate( ComputedCycleLength = StartDateofLastPeriod - StartDateofPeriodBeforeLast ) \%>\%
    mutate( NextMenstrualOnset = branch(menstrual_calculation,
                                   "mc_option1" ~ StartDateofLastPeriod + ComputedCycleLength,
                                   "mc_option2" ~ StartDateofLastPeriod + ReportedCycleLength,
                                   "mc_option3" ~ StartDateNext
  ))
})

}

}
