% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VC_library_writing.R
\name{lib.install}
\alias{lib.install}
\alias{lib.install_if_not_compatible}
\alias{lib.install_tarball}
\title{Install packages and tarballs into R_MV_library}
\usage{
lib.install(
  package_names = NULL,
  lib_location = lib.location(),
  install_temporarily = FALSE,
  allow_overwrite_on_convert = FALSE,
  quiet = TRUE,
  cran_url = "http://cran.us.r-project.org"
)

lib.install_if_not_compatible(
  package_conditions,
  lib_location = lib.location(),
  install_temporarily = FALSE,
  allow_overwrite_on_convert = FALSE,
  quiet = TRUE,
  cran_url = "http://cran.us.r-project.org"
)

lib.install_tarball(
  tarball,
  dependencies = c(),
  lib_location = lib.location(),
  install_temporarily = FALSE,
  allow_overwrite_on_convert = c("tarball", "dependencies"),
  cran_url = "http://cran.us.r-project.org"
)
}
\arguments{
\item{package_names}{Provide a vector of package names.
A version cannot be supplied.}

\item{lib_location}{The folder where this package can be installed.
The package will first be installed in a temporary install folder
\code{<multiversion lib>/TEMP_install_location}
indicated by the \code{\link{lib.location_install_dir}()} function.
If \code{install_temporarily} is set to FALSE (the default),
the installed package(s) is moved to the lib_location automatically.}

\item{install_temporarily}{If FALSE, the installed packages are moved
to the R_MV_library, specified by the \code{lib_location} argument, automatically.
Otherwise it is necessary to run \code{\link{lib.convert}()} manually after
the installation into the temporary folder finished. When multiple tarballs
are provided, this is set to \code{FALSE} with no warning.}

\item{allow_overwrite_on_convert}{Can be used if you are experimenting and
you would like to overwrite the installed (tarball) package.
Only makes sense with \code{install_temporarily} on \code{FALSE}. See details below.}

\item{quiet}{Will affect \code{install.packages(..., quiet = quiet)}.}

\item{cran_url}{Will be passed trough to the install.packages command.}

\item{package_conditions}{Provide a vector of package
name/'version condition' specifications. See section
'limitations for \code{package_conditions}'.}

\item{tarball}{The complete path to the tarball file that you would like to install.}

\item{dependencies}{Provide the dependencies like a package version
combination: \code{c(dplyr = '>= 0.5', data.table = '', R6 = '0.1.1')}.
Note that all dependencies must refer to packages on CRAN. Otherwise install
the dependency manually somewhere and use \code{lib.convert} to include it.}
}
\value{
Nothing is returned, this function is called for it's side-effect of installing a package in the multiversion library.
}
\description{
This family of functions can help with installing packages without
the risk of installing every minor package improvement as soon as it is released.

\enumerate{
  \item{\code{lib.install_tarball} can install a tarball based on the
  tarball location and it's dependencies (like \code{c(dplyr = '> 5.0')}).}
  \item{\code{lib.install_if_not_compatible} can install CRAN package
  depending on a condition. This is especially useful
  (and used on the background) for installing the dependencies for the
  tarball installation.}
  \item{\code{lib.install} can install CRAN packages into the R_MV_library,
  which in return is used by \code{lib.install_if_not_compatible}.}
}
}
\note{
To clean up the installation directory, run \code{lib.clean_install_dir()}.
}
\section{limitations for \code{package_conditions}}{

All version specifications are allowed except for the exact version indication
(e.g. don't provide \code{c(dplyr = '1.2.3')}). It is allowed to provide no
specification, which will match any installed version of that package.
\bold{If the condition is met, the package is skipped}, which is the desired
behavior for dependencies. For an empty condition (e.g. \code{c(dplyr = '')}),
it will only install the package when no version is installed at all.
}

\section{Allow overwrite on convert}{

When an installed package is converted to the R_MV_library, it would normally
show that it failed to copy the packages of which that version was already present.
This means that these packages were already converted from the temporary library
to the R_MV_library structure before, and no \code{lib.clean_install_dir()} was performed yet.
In case you are experimenting with a self made tarball package, and you are
developing the package within the same package version,
it is some times desired to overwrite the already present installed package with a new installation.
For CRAN packages, this options doesn't make sense.\cr\cr
Only for \code{lib.install_tarball}, the options \code{TRUE}, \code{FALSE}, and additionally
\code{"tarball"} \code{"dependencies"} are allowed. 'dependencies' will affect
all packages that are in the temporary installation location except for the tarball package.
'tarball' will only overwrite the tarball package.
}

\section{Installing temporarily}{

Installing a package temporarily gives you the opportunity to test the package
before adding it to the multiversion library structure. Loading packages, including those in the
temporary library (\code{\link{lib.location_install_dir}()}) can be done using:
\code{\link{lib.load}(..., also_load_from_temp_lib = TRUE)}.
}

