% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dft.R
\name{set_to_distribution}
\alias{set_to_distribution}
\alias{distribution_to_set}
\alias{s2d}
\alias{d2s}
\title{Convert between pitch-class sets and distributions}
\usage{
set_to_distribution(set, edo = 12, rounder = 10)

distribution_to_set(
  distro,
  multiset = TRUE,
  reconvert = TRUE,
  edo = 12,
  rounder = 10
)

s2d(...)

d2s(...)
}
\arguments{
\item{set}{Numeric vector of pitch-classes in the set. May be a
multiset, in which case the result is different from the corresponding
set with repetitions removed. Entries must be integers.}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}

\item{rounder}{Numeric (expected integer), defaults to \code{10}:
number of decimal places to round to when testing for equality.}

\item{distro}{Numeric vector representing a pitch-class distribution.}

\item{multiset}{Boolean. Should distribution_to_set() return a multiset if
element weights are greater than 1? Defaults to \code{TRUE}.}

\item{reconvert}{Boolean. Should the scale be converted to the input edo?
Defaults to \code{TRUE}.}

\item{...}{Arguments to be passed from s2d() or d2s() to unabbreviated
functions.}
}
\value{
set_to_distribution() returns a numeric vector with length
\code{edo}, whose \code{i}th entry represents the weight assigned to pitch-class
\code{i} in the distribution. distribution_to_set() returns a (multi)set
represented by listing its elements in a vector. (Non-integer weights are rounded
\emph{up} to the next highest integer if \code{multiset} is \code{TRUE}.)
}
\description{
For applications of the Discrete Fourier Transform to pitch-class
set theory, it's typically convenient to represent musical sets
in terms of \emph{distributions} rather than lists of their elements.
(See Chapter 1 of Amiot 2016, \url{doi:10.1007/978-3-319-45581-5}.)
These functions convert back and forth between those representations.
s2d() and d2s() are shorthands for set_to_distribution() and
distribution_to_set(), respectively.
}
\examples{
set_to_distribution(c(0, 4, 7))
s2d(c(0, 4, 7)) # Same result but quicker to type
s2d(c(0, 4, 4, 7)) # The doubled third is reflected by the value 2 in the result

minor_triad_distro <- c(2, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0)
distribution_to_set(minor_triad_distro)
d2s(minor_triad_distro, multiset=FALSE)

# distribution_to_set automatically converts to 12edo, which
# can sometimes be undesirable, as in this case:
tresillo_distro <- c(1, 0, 0, 1, 0, 0, 1, 0)
d2s(tresillo_distro) 
d2s(tresillo_distro, reconvert=FALSE)

}
