/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui.widgets;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import org.af.commons.Localizer;
import org.af.commons.widgets.WidgetFactory;
import org.af.commons.widgets.validate.RealTextField;
import org.af.jhlir.call.RDataFrame;
import org.af.jhlir.call.RLegalName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mutoss.gui.widgets.AnalysisDialogListenerFactory;
import org.mutoss.gui.widgets.CovariatesSL;
import org.mutoss.gui.widgets.GroupingBox;
import org.mutoss.gui.widgets.GroupingListener;
import org.mutoss.gui.widgets.LevelListenerHazard;
import org.mutoss.gui.widgets.LevelListenerSafety;
import org.mutoss.gui.widgets.LevelOrderListener;
import org.mutoss.gui.widgets.LevelOrderSL;
import org.mutoss.gui.widgets.LevelSelectBox;
import org.mutoss.gui.widgets.LevelSelectionListener;
import org.mutoss.gui.widgets.MarginTable;
import org.mutoss.gui.widgets.MarginTableModelHazard;
import org.mutoss.gui.widgets.MarginTableModelSafety;
import org.mutoss.gui.widgets.ROptionBox;
import org.mutoss.gui.widgets.ResponsesListListenerHazard;
import org.mutoss.gui.widgets.ResponsesListenerSafety;
import org.mutoss.gui.widgets.TypeBoxListener;
import org.mutoss.gui.widgets.VarSelectBox;
import org.mutoss.gui.widgets.VarSelectSL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalysisDialogFactory {
    private static final Log logger = LogFactory.getLog(AnalysisDialogFactory.class);
    protected static Localizer localizer = Localizer.getInstance();

    private static String[] stringListToArray(List<String> list) {
        String[] result = new String[]{};
        result = list.toArray(result);
        return result;
    }

    private static List<RLegalName> getNumVars(RDataFrame df) {
        return df.getNumberVarsLN();
    }

    private static List<RLegalName> getIntVars(RDataFrame df) {
        return df.getIntegerVarsLN();
    }

    private static List<RLegalName> getVars(RDataFrame df) {
        return df.getColNamesLN();
    }

    private static List<RLegalName> getFactorVars(RDataFrame df) {
        return df.getFactorVarsLN();
    }

    public static VarSelectBox makeNumericVarBox(RDataFrame df) {
        return new VarSelectBox(AnalysisDialogFactory.getNumVars(df));
    }

    public static VarSelectBox makeVarBox(RDataFrame df) {
        return new VarSelectBox(AnalysisDialogFactory.getVars(df));
    }

    public static VarSelectBox makeIntegerVarBox(RDataFrame df) {
        return new VarSelectBox(AnalysisDialogFactory.getIntVars(df));
    }

    public static VarSelectSL makeResponsesList(RDataFrame df) {
        return new VarSelectSL(df.getNumberVarsLN());
    }

    public static VarSelectSL makeRegressorsList(RDataFrame df) {
        return new VarSelectSL(df.getColNamesLN());
    }

    public static VarSelectBox makeFactorVarBox(RDataFrame df) {
        return new VarSelectBox(AnalysisDialogFactory.getFactorVars(df));
    }

    public static VarSelectBox makeFactorNumVarBox(RDataFrame df) {
        ArrayList<RLegalName> v = new ArrayList<RLegalName>();
        v.addAll(df.getNumberVarsLN());
        v.addAll(df.getFactorVarsLN());
        return new VarSelectBox(v);
    }

    public static JComboBox makeFactorAndIntVarBox(RDataFrame df) {
        List list = df.getFactorVars();
        list.addAll(df.getIntegerVars());
        return new JComboBox<Object>(list.toArray());
    }

    public static LevelSelectBox makeLevelSelectionBox(RDataFrame df, VarSelectBox factorBox) {
        LevelSelectBox b = new LevelSelectBox();
        AnalysisDialogListenerFactory.updateLevelSelectionBox(df, factorBox, b);
        new LevelSelectionListener(df, factorBox, b);
        return b;
    }

    public static GroupingBox makeGroupingComboBox(RDataFrame df) {
        GroupingBox gcb = new GroupingBox(AnalysisDialogFactory.getFactorVars(df));
        RLegalName g = GroupingListener.getLastGrouping();
        if (g != null && gcb.getAllGroupings().contains(g)) {
            gcb.setSelectedItem(g);
        }
        gcb.addActionListener(new GroupingListener());
        return gcb;
    }

    public static LevelOrderSL makeLevelOrderSL(RDataFrame df, VarSelectBox factorBox) {
        LevelOrderSL sl = new LevelOrderSL();
        new LevelOrderListener(df, factorBox, sl);
        return sl;
    }

    public static VarSelectSL makeVarSelectSL(RDataFrame df) {
        return new VarSelectSL(AnalysisDialogFactory.getVars(df));
    }

    public static CovariatesSL makeCovariatesSL(RDataFrame df) {
        ArrayList<RLegalName> v = new ArrayList<RLegalName>();
        v.addAll(df.getNumberVarsLN());
        v.addAll(df.getFactorVarsLN());
        return new CovariatesSL(v);
    }

    public static VarSelectSL makeFactorsSL(RDataFrame df) {
        ArrayList<RLegalName> v = new ArrayList<RLegalName>();
        v.addAll(df.getFactorVarsLN());
        return new VarSelectSL(v);
    }

    public static VarSelectSL makeIntegersSL(RDataFrame df) {
        ArrayList<RLegalName> v = new ArrayList<RLegalName>();
        v.addAll(df.getIntegerVarsLN());
        return new VarSelectSL(v);
    }

    public static VarSelectSL makeNumsSL(RDataFrame df) {
        ArrayList<RLegalName> v = new ArrayList<RLegalName>();
        v.addAll(df.getNumericVarsLN());
        return new VarSelectSL(v);
    }

    public static ROptionBox<String> makeAlternativeBox1() {
        String[] a = new String[]{localizer.getString("SHARED_DIALOGFACTORY_TWOSIDED"), localizer.getString("SHARED_DIALOGFACTORY_LESS"), localizer.getString("SHARED_DIALOGFACTORY_GREATER")};
        String[] b = new String[]{"two.sided", "less", "greater"};
        return new ROptionBox<String>("alternative", a, b);
    }

    public static ROptionBox<String> makeAlternativeBox1b() {
        String[] a = new String[]{localizer.getString("SHARED_DIALOGFACTORY_LESS"), localizer.getString("SHARED_DIALOGFACTORY_GREATER")};
        String[] b = new String[]{"less", "greater"};
        return new ROptionBox<String>("alternative", a, b);
    }

    public static ROptionBox<String> makeAlternativeBox2() {
        String[] a = new String[]{localizer.getString("SHARED_DIALOGFACTORY_TWOSIDED"), localizer.getString("SHARED_DIALOGFACTORY_LOWER"), localizer.getString("SHARED_DIALOGFACTORY_UPPER")};
        String[] b = new String[]{"two.sided", "lower", "upper"};
        return new ROptionBox<String>("alternative", a, b);
    }

    public static ROptionBox<String> makeDistBox1() {
        String[] a = new String[]{"Negative Binomial", "Quasipoisson", "Poisson"};
        String[] b = new String[]{"NegBin", "QuasiPoisson", "Poisson"};
        return new ROptionBox<String>("dist", a, b);
    }

    public static ROptionBox<String> makeDistBox2() {
        String[] a = new String[]{"Quasibinomial", "Betabinomial", "Binomial"};
        String[] b = new String[]{"QuasiBinomial", "BetaBinomial", "Binomial"};
        return new ROptionBox<String>("dist", a, b);
    }

    public static ROptionBox<String> makeTypeBox1() {
        String[] a = new String[]{localizer.getString("SHARED_DIALOGFACTORY_RATIO"), localizer.getString("SHARED_DIALOGFACTORY_DIFFERENCE")};
        String[] b = new String[]{"ratio", "difference"};
        ROptionBox<String> cb = new ROptionBox<String>("type", a, b);
        return cb;
    }

    public static ROptionBox<String> makeTypeBox2() {
        String[] a = new String[]{localizer.getString("SHARED_DIALOGFACTORY_RATIO"), localizer.getString("SHARED_DIALOGFACTORY_DIFFERENCE"), localizer.getString("SHARED_DIALOGFACTORY_ODDSRATIO")};
        String[] b = new String[]{"ratio", "difference", "oddsratio"};
        return new ROptionBox<String>("type", a, b);
    }

    public static ROptionBox<String> makeComparisonBox1() {
        String[] a = new String[]{"Comparison to Control", "Trend", "Down-turn-protected trend", "Vehicle-Doses-Active", "Comparison to grand mean"};
        String[] b = new String[]{"Dunnett", "Williams", "UmbrellaWilliams", "VDsA", "GrandMean"};
        return new ROptionBox<String>("cmenthod", a, b);
    }

    public static ROptionBox<String> makeComparisonBox1x() {
        String[] a = new String[]{"Comparison to Control", "Trend", "Down-turn-protected trend", "Vehicle-Doses-Active", "Comparison to grand mean", "User defined"};
        String[] b = new String[]{"Dunnett", "Williams", "UmbrellaWilliams", "VDsA", "GrandMean", "UserDefined"};
        return new ROptionBox<String>("cmenthod", a, b);
    }

    public static ROptionBox<String> makeComparisonBox2() {
        String[] a = new String[]{"Comparison to Control", "Trend", "Down-turn-protected trend"};
        String[] b = new String[]{"Dunnett", "Williams", "UmbrellaWilliams"};
        return new ROptionBox<String>("cmenthod", a, b);
    }

    public static ROptionBox<String> makeComparisonBox2x() {
        String[] a = new String[]{"Comparison to Control", "Trend", "Down-turn-protected trend", "User defined"};
        String[] b = new String[]{"Dunnett", "Williams", "UmbrellaWilliams", "UserDefined"};
        return new ROptionBox<String>("cmenthod", a, b);
    }

    public static ROptionBox<String> makeComparisonBox3() {
        String[] a = new String[]{"Trend", "Down-turn-protected trend", "Change Point"};
        String[] b = new String[]{"Williams", "UmbrellaWilliams", "ChangePoint"};
        return new ROptionBox<String>("cmenthod", a, b);
    }

    public static ROptionBox<String> makeComparisonBox4() {
        String[] a = new String[]{"Comparison to Control", "Trend", "Down-turn-protected trend", "All-pair", "Sequence", "Change Point"};
        String[] b = new String[]{"Dunnett", "Williams", "UmbrellaWilliams", "Tukey", "Sequen", "Changepoint"};
        return new ROptionBox<String>("cmenthod", a, b);
    }

    public static ROptionBox<String> makeComparisonBox5() {
        String[] a = new String[]{"Comparison to Control", "All-pair", "Sequence"};
        String[] b = new String[]{"Dunnett", "Tukey", "Sequen"};
        return new ROptionBox<String>("cmenthod", a, b);
    }

    public static ROptionBox<String> makeCorStructBox() {
        String[] a = new String[]{"No Correlation Structure", "Autoregressive Order 1", "Continuous Autoregressive Order 1", "Unstructured"};
        String[] b = new String[]{"no", "AR1", "CAR1", "UN"};
        return new ROptionBox<String>("cmenthod", a, b);
    }

    public static ROptionBox<String> makeDoseScoreBox() {
        String[] a = new String[]{"ordinal", "log-lin", "numeric"};
        String[] b = new String[]{"ordinal", "loglin", "num"};
        return new ROptionBox<String>("scoretype", a, b);
    }

    public static ROptionBox<String> makeVarianceBox2() {
        String[] a = new String[]{localizer.getString("SHARED_DIALOGFACTORY_HETEROGENOUS"), localizer.getString("SHARED_DIALOGFACTORY_HOMOGENOUS"), "Bofinger (Only for Type: Difference)"};
        String[] b = new String[]{"var.unequal", "var.equal", "Bofinger"};
        return new ROptionBox<String>("var.equal", a, b);
    }

    public static ROptionBox<Boolean> makeVarianceBox() {
        String[] a = new String[]{localizer.getString("SHARED_DIALOGFACTORY_HETEROGENOUS"), localizer.getString("SHARED_DIALOGFACTORY_HOMOGENOUS")};
        Boolean[] b = new Boolean[]{false, true};
        return new ROptionBox<Boolean>("var.equal", a, b);
    }

    public static RealTextField makeConfidenceField() {
        RealTextField tf = new RealTextField("Confidence", 0.5, 1.0, false, false);
        tf.setText("0.95");
        return tf;
    }

    public static RealTextField makeAlphaField() {
        RealTextField tf = new RealTextField("Alpha", 0.0, 0.5, false, false);
        tf.setText("0.05");
        return tf;
    }

    public static RealTextField makeMarginField(ROptionBox<String> typeBox) {
        RealTextField tf = new RealTextField("Testmargin");
        if (((String)typeBox.getSelectedObject()).equals("difference")) {
            tf.setText("0");
        } else {
            tf.setText("1");
        }
        new TypeBoxListener(typeBox, tf);
        return tf;
    }

    public static MarginTable makeMarginTableHazard(VarSelectSL responsesList, ROptionBox<String> cbType) {
        MarginTable tableMargin = new MarginTable(new MarginTableModelHazard(cbType.getSelectedName().equals("Ratio")));
        new ResponsesListListenerHazard(responsesList, cbType, tableMargin);
        return tableMargin;
    }

    public static MarginTable makeMarginTableHazard(LevelOrderSL slLevelOrder, ROptionBox<String> cbType) {
        MarginTable tableMargin = new MarginTable(new MarginTableModelHazard(cbType.getSelectedName().equals("Ratio")));
        new LevelListenerHazard(slLevelOrder, cbType, tableMargin);
        return tableMargin;
    }

    public static MarginTable makeMarginTableSafety(VarSelectSL responsesList, ROptionBox<String> cbType) {
        MarginTable tableMargin = new MarginTable(new MarginTableModelSafety(cbType.getSelectedName().equals("Ratio")));
        new ResponsesListenerSafety(responsesList, cbType, tableMargin);
        return tableMargin;
    }

    public static MarginTable makeMarginTableSafety(LevelOrderSL slLevelOrder, ROptionBox<String> cbType) {
        MarginTable tableMargin = new MarginTable(new MarginTableModelSafety(cbType.getSelectedName().equals("Ratio")));
        new LevelListenerSafety(slLevelOrder, cbType, tableMargin);
        return tableMargin;
    }

    public static Box makeEnablerBox(Component component) {
        JCheckBox chb = new JCheckBox();
        WidgetFactory.registerEnabler((JCheckBox)chb, (Component)component);
        return AnalysisDialogFactory.makeEnablerBox(component, chb, true);
    }

    public static Box makeEnablerBox(Component component, JCheckBox enabler) {
        return AnalysisDialogFactory.makeEnablerBox(component, enabler, true);
    }

    public static Box makeEnablerBox(Component component, JCheckBox enabler, boolean boxIsLeft) {
        Box box = Box.createHorizontalBox();
        if (boxIsLeft) {
            box.add(enabler);
            box.add(component);
        } else {
            box.add(component);
            box.add(enabler);
        }
        return box;
    }

    public static ROptionBox<String> makeAsyMethod() {
        String[] a = new String[]{"Logit", "Probit", "Multi-Normal", "Multi-t"};
        String[] b = new String[]{"logit", "probit", "normal", "mult.t"};
        return new ROptionBox<String>("asymenthod", a, b);
    }
}

