% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stan_utils.R
\name{code}
\alias{code}
\alias{stancode.mvgam_prefit}
\alias{stancode.mvgam}
\alias{standata.mvgam_prefit}
\title{Stan code and data objects for \pkg{mvgam} models}
\usage{
code(object)

\method{stancode}{mvgam_prefit}(object, ...)

\method{stancode}{mvgam}(object, ...)

\method{standata}{mvgam_prefit}(object, ...)
}
\arguments{
\item{object}{An object of class \code{mvgam} or \code{mvgam_prefit},
returned from a call to \code{mvgam}}

\item{...}{ignored}
}
\value{
Either a character string containing the fully commented \pkg{Stan} code
to fit a \pkg{mvgam} model or a named list containing the data objects needed
to fit the model in Stan.
}
\description{
Generate Stan code and data objects for \pkg{mvgam} models
}
\examples{
\donttest{
simdat <- sim_mvgam()
mod <- mvgam(y ~ s(season) +
               s(time, by = series),
             family = poisson(),
             data = simdat$data_train,
             run_model = FALSE)

# View Stan model code
stancode(mod)

# View Stan model data
sdata <- standata(mod)
str(sdata)
}

}
