% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiple.imputation.R
\name{multiple.imputation}
\alias{multiple.imputation}
\title{Multiple imputation function}
\usage{
multiple.imputation(data, prior.params, initial.values, iter, verbose = TRUE)
}
\arguments{
\item{data}{a list of data containing the lower and upper bounds information for the missing and censored values.}

\item{prior.params}{list of prior parameter specifications.}

\item{initial.values}{list of initial values.}

\item{iter}{number of rounds for doing multiple imputation.}

\item{verbose}{boolean variable indicating whether the running status is printed in the console. Default is set to TRUE.}
}
\value{
A list including the simulated mean and variance values of the assumed normal model, the covariance matrix, the imputed data,
and the conditional model parameters across different iterations of multiple imputation.
}
\description{
Multiply imputes the missing and censored values in multivariate data.
}
\details{
A multivariate normal model is assumed on the data, the sweep operator is adopted to
calculate the parameters of the conditional models. The implemented multiple imputation algorithm
is based on the data augmentation algorithm proposed by Tanner and Wong (1987). The Gibbs sampling algorithm
is adopted to update the model parameters and draw imputations of the coarse data. Output is a
list including the parameters of the normal models and the imputed data across different iterations
of multiple imputation.
}
\examples{

### data and indicator
miss.dat <- simulated.dat[[1]]
data.ind <- simulated.dat[[2]]

### number of observations and variables
n <- nrow(miss.dat); p <- ncol(miss.dat)

#### bound matrices
b1 <- b2 <- matrix(nrow = nrow(data.ind), ncol = ncol(data.ind))

for (i in 1:nrow(b1)) {
  for (j in 1:ncol(b1)) {
    b1[i, j] <- ifelse(data.ind[i, j] != 1, NA,
                       miss.dat[i, j])
    b2[i, j] <- ifelse(data.ind[i, j] == 0, NA, miss.dat[i, j])
  }
}
colnames(b1) <- colnames(b2) <- colnames(miss.dat)

#### create a matrix for including the lower and upper bounds
bounds <- list()
bounds[[1]] <- b1; bounds[[2]] <- b2

### prior specifications
prior.param <- list(
  mu.0 = rep(0, p),
  Lambda.0 = diag(100, p),
  kappa.0 = 2,
  nu.0 = p * (p + 1) / 2
)

### starting values
start.vals <- list(
  mu = rep(0, p),
  sigma = diag(100, p)
)


### MI
num.iter <- 500

begin <- Sys.time()
sim.res <- multiple.imputation(
  bounds,
  prior.param,
  start.vals,
  num.iter,
  FALSE
)

}
\references{
Goodnight, J. H. (1979). A tutorial on the SWEEP operator. \emph{The American Statistician}, \bold{33(3)}, 149-158.

Tanner, M., & Wong, W. (1987). The Calculation of Posterior Distributions by Data Augmentation.
\emph{Journal of the American Statistical Association}, \bold{82(398)}, 528-540.
}
