% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error_struct.R
\name{error_structure}
\alias{error_structure}
\alias{error_structure.mvord}
\title{Extracts Error Structure of Multivariate Ordinal Regression Models.}
\usage{
error_structure(object, type, ...)

\method{error_structure}{mvord}(object, type = NULL, ...)
}
\arguments{
\item{object}{an object of class \code{'mvord'}.}

\item{type}{choose type \code{"sigmas"}, \code{"alpha"}, \code{"corr"}, or \code{"z"}.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
A generic function which extracts for each subject the estimated
error structure parameters from objects of class \code{'mvord'}.
}
\details{
\itemize{
\item{\code{sigmas}} {extracts the correlation/covariance matrices corresponding to each subject.
            Applicable in line with \code{cor_general, cov_general, cor_equi, cor_ar1}.}
\item{\code{alpha}} {extracts the parameters of the covariate dependent error structure.
Applicable in line with \code{cor_equi, cor_ar1}.}
\item{\code{corr}} {extracts the subject-specific correlation parameters. Applicable in
line with \code{cor_equi}, \code{cor_ar1}.}
\item{\code{z}} {extracts the subject-specific Fisher-z score. Applicable in line
with \code{cor_equi, cor_ar1}.}}
}
