% Generated by roxygen2 (4.0.2): do not edit by hand
\name{blurSignal}
\alias{blurSignal}
\title{Blur an input signal}
\usage{
blurSignal(signal, G)
}
\arguments{
\item{signal}{A numeric vector of length n of the signal of interest}

\item{G}{An n by m matrix of blur functions to be applied to the signal of interest.}
}
\description{
An input signal is blurred by a set of functions to obtain a blurred multichannel signal.
}
\details{
Applies the convolution operator to the signal of interest with each column of G to create a multichannel blurred signal. This operation is done in the Fourier domain using the base R fft transforms.
}
\examples{
n <- 1024
m <- 3
blur <- gammaBlur(n, shape = seq(from = 0.5, to = 1, length = m), scale = rep(0.25, m))
x <- (1:n)/n
signal <- makeLIDAR(n)
par(mfrow = c(2,1))
plot(x, signal, type = 'l', main = 'Direct LIDAR signal')
indirectSignal <- blurSignal(signal, blur)
matplot(x, indirectSignal, type = 'l', main = 'Set of blurred LIDAR signals')
}
\seealso{
\code{\link{gammaBlur}}, \code{\link{boxcarBlur}}
}

