% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/functions.R
\name{detectBlur}
\alias{detectBlur}
\title{Detect type of blur}
\usage{
detectBlur(G)
}
\arguments{
\item{G}{The input blur matrix to be analysed and checked whether it corresponds to direct blur or box.car blur.}
}
\description{
Detect the form of the input blur matrix, G
}
\details{
Detects if the input blur matrix, G, has uniform structure in being of direct blur type everywhere or box.car type everywhere. In those cases, it will return a character string 'direct' or 'box.car' respectively, otherwise it returns 'smooth'. This is done in the direct blur case by checking that the mvfft(G) is equal to 1 everywhere (complex part is zero everywhere) and in the box.car case by checking that each column has two unique values, a zero and positive value. If the blur type is not identified to be direct or box.car, the string 'smooth' is returned.
}

