/*
 * Decompiled with CFR 0.152.
 */
package ru.itmo.ctlab.virgo.sgmwcs.solver;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ru.itmo.ctlab.virgo.sgmwcs.Signals;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Edge;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Graph;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Node;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Unit;
import ru.itmo.ctlab.virgo.sgmwcs.solver.Dijkstra;
import ru.itmo.ctlab.virgo.sgmwcs.solver.Utils;

public class Preprocessor {
    private Node root = null;
    private int logLevel = 0;
    private int numThreads;
    private Graph graph;
    private Signals signals;
    private Node primaryNode;
    private final Step<Node> cns = new Step(this::cns, "cns");
    private final Step<Node> npv2 = new Step(this::npv2, "npv2");
    private final Step<Node> leaves = new Step(this::leaves, "leaves");
    private final Step<Edge> npe = new Step(this::uselessEdges, "npe");
    private final Step<Edge> nnp = new Step(this::nnp, "nnp");

    public void setLogLevel(int level) {
        this.logLevel = level;
    }

    public Preprocessor(Graph graph, Signals signals, int numThreads, int logLevel) {
        this(graph, signals);
        this.numThreads = numThreads;
        this.logLevel = logLevel;
    }

    public Preprocessor(Graph graph, Signals signals) {
        this.graph = graph;
        this.signals = signals;
        this.numThreads = 0;
        this.logLevel = 0;
    }

    public void setRoot(Node r) {
        this.root = r;
    }

    private double weight(Unit unit) {
        return this.signals.weight(unit);
    }

    private boolean positive(Unit unit) {
        return this.signals.minSum(unit) >= 0.0;
    }

    private boolean nonPositive(Unit unit) {
        return this.signals.minSum(unit) <= 0.0;
    }

    private boolean bijection(Unit unit) {
        return this.signals.bijection(unit);
    }

    public void preprocessBasic() {
        this.posC();
        this.negC();
        this.primaryNode = this.root;
        HashSet toRemove = new HashSet();
        if (this.root != null) {
            for (Node v : new ArrayList<Node>(this.graph.vertexSet())) {
                if (!this.positive(v) || this.primaryNode != null && !(this.weight(v) > this.weight(this.primaryNode))) continue;
                this.primaryNode = v;
            }
        }
        if (this.primaryNode != null) {
            new Step(s -> this.negR(this.primaryNode, this.primaryNode, (Set<Node>)new HashSet<Node>(), (Set<Node>)s), "negR").apply(toRemove);
        }
    }

    public void preprocess(int preprocessLevel) {
        int removed;
        if (this.logLevel > 0) {
            System.out.println("Starting preprocessing");
        }
        this.removeSelfLoops();
        this.removeParallelEdges();
        if (preprocessLevel == 0) {
            return;
        }
        if (preprocessLevel == 1) {
            this.preprocessBasic();
            return;
        }
        do {
            removed = this.iteration();
            if (this.logLevel <= 1) continue;
            System.out.println("Removed " + removed + " units");
        } while (removed > 0);
    }

    private void removeSelfLoops() {
        for (Node n : this.graph.vertexSet()) {
            for (Edge e : this.graph.edgesOf(n)) {
                if (!this.graph.getOppositeVertex(n, e).equals(n)) continue;
                this.graph.removeEdge(e);
                Unit[] unitArray = new Unit[]{e};
                if (!(this.signals.minSum(unitArray) >= 0.0)) continue;
                this.absorb(n, e);
            }
        }
    }

    private void removeParallelEdges() {
        HashSet<Edge> edges = new HashSet<Edge>(this.graph.edgeSet());
        HashSet<Edge> used = new HashSet<Edge>();
        for (Edge e : edges) {
            if (used.contains(e)) continue;
            List<Edge> otherEdges = this.graph.getAllEdges(this.graph.getEdgeSource(e), this.graph.getEdgeTarget(e));
            otherEdges.remove(e);
            for (Edge other : otherEdges) {
                Unit[] unitArray = new Unit[]{other};
                if (this.signals.minSum(unitArray) < 0.0 && this.signals.minSum(other) < this.signals.minSum(e) || this.signals.unitSets((Unit)e).containsAll(this.signals.unitSets((Unit)other))) {
                    this.graph.removeEdge(other);
                    used.add(other);
                    continue;
                }
                Unit[] unitArray2 = new Unit[]{e};
                if (!(this.signals.minSum(unitArray2) >= 0.0)) continue;
                this.absorb(e, other);
                this.graph.removeEdge(other);
                used.add(other);
            }
        }
    }

    private int iteration() {
        int res = 0;
        HashSet toRemove = new HashSet();
        this.primaryNode = this.root;
        if (this.primaryNode == null) {
            for (Node node : new ArrayList<Node>(this.graph.vertexSet())) {
                if (this.primaryNode != null && !(this.weight(node) > this.weight(this.primaryNode))) continue;
                this.primaryNode = node;
            }
        }
        if (this.primaryNode != null) {
            res += this.leaves.apply(toRemove);
        }
        res += this.cns.apply(toRemove);
        this.negC();
        this.posC();
        this.primaryNode = this.root;
        Node posNode = null;
        if (this.primaryNode == null) {
            for (Node v : new ArrayList<Node>(this.graph.vertexSet())) {
                if (this.primaryNode != null && !(this.weight(v) > this.weight(this.primaryNode))) continue;
                posNode = this.primaryNode;
                this.primaryNode = v;
            }
        }
        if (this.primaryNode != null) {
            res += new Step(s -> this.negR(this.primaryNode, this.primaryNode, (Set<Node>)new HashSet<Node>(), (Set<Node>)s), "negR").apply(toRemove);
        }
        if (posNode != null && this.graph.containsVertex(posNode)) {
            Node node = posNode;
            res += new Step(s -> this.negR(pn, pn, (Set<Node>)new HashSet<Node>(), (Set<Node>)s), "negR").apply(toRemove);
        }
        AbstractSet abstractSet = this.numThreads == 1 ? new HashSet() : new ConcurrentSkipListSet();
        res += this.npe.apply(abstractSet);
        res += this.nnp.apply(abstractSet);
        return res += this.npv2.apply(toRemove);
    }

    /*
     * Unable to fully structure code
     */
    private boolean negR(Node v, Node r, Set<Node> vis, Set<Node> toRemove) {
        safe = false;
        vis.add(v);
        units = new ArrayList<Node>(vis);
        for (Edge e : this.graph.edgesOf(v)) {
            minSum = this.signals.minSum(units);
            u = this.graph.getOppositeVertex(v, e);
            if (vis.contains(u)) {
                if (u == r || toRemove.contains(u)) continue;
                safe = true;
                continue;
            }
            res = this.negR(u, v, vis, toRemove);
            units.add(u);
            if (minSum <= this.signals.minSum(units)) ** GOTO lbl-1000
            v0 = new Unit[]{u};
            if (this.signals.maxSum(v0) > 0.0) lbl-1000:
            // 2 sources

            {
                res = true;
            } else {
                minSum = this.signals.minSum(units);
                for (Edge edge : this.graph.getAllEdges(v, u)) {
                    units.add((Node)edge);
                    if (minSum <= this.signals.minSum(units)) {
                        res = true;
                    }
                    units.remove(units.size() - 1);
                }
            }
            if (!res) {
                toRemove.add(u);
            }
            safe = res != false || safe != false;
            units.remove(units.size() - 1);
        }
        return safe;
    }

    private void nnp(Set<Edge> toRemove) {
        for (Edge e : this.graph.edgeSet()) {
            if (this.signals.minSum(e) > 0.0) continue;
            Node u = this.graph.getEdgeTarget(e);
            Node v = this.graph.getEdgeSource(e);
            for (Node n : this.graph.neighborListOf(v)) {
                Edge eu = this.graph.getEdge(n, v);
                if (eu == e || this.signals.minSum(eu, n) < this.signals.minSum(e) || !this.graph.neighborListOf(n).contains(u)) continue;
                Edge ev = this.graph.getEdge(n, u);
                if (toRemove.contains(eu) || toRemove.contains(ev)) continue;
                Set<Integer> pos = this.signals.positiveUnitSets((Unit)e);
                double lowest = Math.min(this.signals.minSum(eu, ev), this.signals.minSum(eu, ev, n));
                double lowest2 = Math.min(this.signals.minSum(eu), this.signals.minSum(ev));
                lowest = Math.min(lowest, lowest2);
                Unit[] unitArray = new Unit[]{e};
                if (!(lowest >= this.signals.minSum(unitArray)) || !this.signals.positiveUnitSets(eu, n, u, v).containsAll(pos) || !this.signals.positiveUnitSets(ev, n, u, v).containsAll(pos)) continue;
                toRemove.add(e);
            }
        }
    }

    private void negC() {
        for (Node v : new ArrayList<Node>(this.graph.vertexSet())) {
            Node right;
            Edge[] edges;
            Unit[] unitArray = new Unit[]{v};
            if (!(this.signals.maxSum(unitArray) <= 0.0) || this.graph.degreeOf(v) != 2 || this.signals.maxSum((edges = this.graph.edgesOf(v).toArray(new Edge[0]))[1]) > 0.0 || this.signals.maxSum(edges[0]) > 0.0) continue;
            Node left = this.graph.getOppositeVertex(v, edges[0]);
            if (left.equals(right = this.graph.getOppositeVertex(v, edges[1]))) {
                this.graph.removeVertex(v);
                continue;
            }
            this.graph.removeVertex(v);
            this.absorb(edges[0], v);
            this.absorb(edges[0], edges[1]);
            this.graph.addEdge(left, right, edges[0]);
        }
    }

    private void posC() {
        for (Edge edge : new ArrayList<Edge>(this.graph.edgeSet())) {
            if (!this.graph.containsEdge(edge)) continue;
            Node from = this.graph.getEdgeSource(edge);
            Node to = this.graph.getEdgeTarget(edge);
            if (!this.positive(edge) || !this.positive(from) || !this.positive(to)) continue;
            this.merge(edge, from, to);
        }
    }

    private void merge(Unit ... units) {
        HashSet<Node> nodes = new HashSet<Node>();
        HashSet<Edge> edges = new HashSet<Edge>();
        for (Unit unit : units) {
            if (unit instanceof Node) {
                nodes.add((Node)unit);
                continue;
            }
            edges.add((Edge)unit);
        }
        for (Edge e : edges) {
            if (nodes.contains(this.graph.getEdgeSource(e)) && nodes.contains(this.graph.getEdgeTarget(e))) continue;
            throw new IllegalArgumentException();
        }
        for (Edge e : edges) {
            this.contract(e);
        }
    }

    public void contract(Edge e) {
        Node main = this.graph.getEdgeSource(e);
        Node aux = this.graph.getEdgeTarget(e);
        HashSet<Edge> auxEdges = new HashSet<Edge>(this.graph.edgesOf(aux));
        auxEdges.remove(e);
        for (Edge a : auxEdges) {
            Node opposite = this.graph.getOppositeVertex(aux, a);
            Edge m = this.graph.getEdge(main, opposite);
            this.graph.removeEdge(a);
            if (m == null) {
                if (opposite == main) {
                    if (!this.positive(a)) continue;
                    this.absorb(main, a);
                    continue;
                }
                this.graph.addEdge(main, opposite, a);
                continue;
            }
            if (this.positive(a) && this.positive(m)) {
                this.absorb(m, a);
                continue;
            }
            this.graph.addEdge(main, opposite, a);
        }
        this.graph.removeVertex(aux);
        this.absorb(main, aux);
        this.absorb(main, e);
    }

    private void leaves(Set<Node> toRemove) {
        HashMap toAbsorb = new HashMap();
        for (Node node : this.graph.vertexSet()) {
            Set<Edge> edges = this.graph.edgesOf(node);
            if (edges.size() != 1 || this.weight(node) == this.weight(this.primaryNode)) continue;
            Edge edge = edges.stream().findAny().orElse(null);
            Node opposite = this.graph.getOppositeVertex(node, edge);
            double minSum = this.signals.minSum(edge, node, opposite);
            Unit[] unitArray = new Unit[]{opposite};
            if (minSum >= this.signals.minSum(unitArray) && this.graph.degreeOf(opposite) > 1) {
                toAbsorb.putIfAbsent(opposite, new ArrayList());
                ((List)toAbsorb.get(opposite)).addAll(Arrays.asList(node, edge));
                toRemove.add(node);
                continue;
            }
            Unit[] unitArray2 = new Unit[]{edge, node, opposite};
            Unit[] unitArray3 = new Unit[]{opposite};
            if (this.signals.sum(unitArray2) <= this.signals.sum(unitArray3)) {
                toRemove.add(node);
                continue;
            }
            for (Node other : this.graph.neighborListOf(opposite)) {
                if (toRemove.contains(other) || other == node) continue;
                Edge otherEdge = this.graph.getEdge(other, opposite);
                if (!this.signals.positiveUnitSets(otherEdge, other).containsAll(this.signals.positiveUnitSets(node, edge))) continue;
                Unit[] unitArray4 = new Unit[]{otherEdge, other};
                Unit[] unitArray5 = new Unit[]{node, edge};
                if (!(this.signals.minSum(unitArray4) >= this.signals.minSum(unitArray5))) continue;
                toRemove.add(node);
            }
        }
        for (Map.Entry entry : toAbsorb.entrySet()) {
            List willAbsorb = (List)entry.getValue();
            willAbsorb.forEach(val -> this.absorb((Unit)kvp.getKey(), (Unit)val));
        }
    }

    private boolean positiveEdge(Node u, Node v) {
        return this.graph.getAllEdges(u, v).stream().anyMatch(this::positive);
    }

    private Stream<Node> positiveNeighbors(Node v) {
        return this.graph.neighborListOf(v).stream().filter(n -> this.positive((Unit)n) && this.positiveEdge((Node)n, v));
    }

    private void cns(Set<Node> toRemove) {
        Set<Node> vertexSet = this.graph.vertexSet();
        for (Node v : vertexSet) {
            if (toRemove.contains(v)) continue;
            double vWorst = this.signals.minSum(v);
            Set w = this.positiveNeighbors(v).collect(Collectors.toSet());
            w.add(v);
            Set<Integer> ws = this.signals.unitSets(w);
            Set wnbs = w.stream().flatMap(n -> this.graph.neighborListOf((Node)n).stream()).collect(Collectors.toSet());
            for (Node n2 : wnbs) {
                List<Node> neighbors = this.graph.neighborListOf(n2);
                for (Node r : neighbors) {
                    if (w.contains(r) || r == this.root) continue;
                    Set<Edge> edges = this.graph.edgesOf(r);
                    Set<Integer> rs = this.signals.positiveUnitSets(edges);
                    rs.addAll(this.signals.positiveUnitSets((Unit)r));
                    Unit[] unitArray = new Unit[]{r};
                    double bestSum = this.signals.minSum(unitArray);
                    if (!(vWorst >= bestSum) || !ws.containsAll(rs) || !w.containsAll(this.graph.neighborListOf(r))) continue;
                    toRemove.add(r);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uselessEdges(Set<Edge> toRemove) {
        ExecutorService executor;
        if (this.numThreads > 1) {
            executor = Executors.newFixedThreadPool(this.numThreads);
            Preprocessor preprocessor = this;
            synchronized (preprocessor) {
                this.graph.subgraph(this.graph.vertexSet());
            }
        } else {
            executor = new Utils.CurrentThreadExecutorService();
        }
        this.parallelUselessEdges(toRemove, executor);
    }

    private void parallelUselessEdges(Set<Edge> toRemove, ExecutorService executor) {
        for (Node u : this.graph.vertexSet()) {
            executor.execute(() -> {
                Dijkstra dijkstra = new Dijkstra(this.graph, this.signals);
                this.npeIteration(dijkstra, u, toRemove);
            });
        }
        executor.shutdown();
        try {
            executor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void npeIteration(Dijkstra dijkstra, Node u, Set<Edge> toRemove) {
        List<Node> neighbors = this.graph.neighborListOf(u).stream().filter(n -> this.graph.getAllEdges((Node)n, u).stream().anyMatch(this::nonPositive)).collect(Collectors.toList());
        if (neighbors.isEmpty()) {
            return;
        }
        Set<Edge> res = dijkstra.solveNE(u, neighbors);
        for (Edge edge : res) {
            toRemove.add(edge);
        }
    }

    private void npv2(Set<Node> toRemove) {
        Dijkstra dijkstra = new Dijkstra(this.graph, this.signals);
        for (Node n : this.graph.vertexSet()) {
            if (n == this.primaryNode || !this.checkNeg(n) || this.graph.neighborListOf(n).stream().anyMatch(toRemove::contains) || !dijkstra.solveNP(n)) continue;
            toRemove.add(n);
        }
    }

    private boolean checkNeg(Node n) {
        return this.graph.degreeOf(n) == 2 && this.negWithEdges(n);
    }

    private boolean negWithEdges(Node n) {
        Edge[] e = this.graph.edgesOf(n).toArray(new Edge[0]);
        Set<Integer> es = this.signals.positiveUnitSets(this.graph.edgesOf(n));
        es.addAll(this.signals.unitSets((Unit)n));
        return this.signals.weightSum(es) + Math.max(this.signals.weightSum(this.signals.negativeUnitSets((Unit)e[0])), this.signals.weightSum(this.signals.negativeUnitSets((Unit)e[1]))) <= 0.0;
    }

    private void absorb(Unit who, Unit whom) {
        who.absorb(whom);
        this.signals.join(whom, who);
    }

    private class Step<T extends Unit> {
        private Consumer<Set<T>> test;
        private String name;

        Step(Consumer<Set<T>> test, String name) {
            this.name = name;
            this.test = test;
        }

        int apply(Set<T> toRemove) {
            toRemove.clear();
            this.test.accept(toRemove);
            int res = toRemove.size();
            if (Preprocessor.this.logLevel > 1) {
                System.out.println(this.name + " test: " + res + " units to remove.");
            }
            for (Unit t : toRemove) {
                Preprocessor.this.graph.removeUnit(t);
            }
            return res;
        }
    }
}

