% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/registration_helpers.R
\name{run_registration}
\alias{run_registration}
\title{Internal function to register one marker}
\usage{
run_registration(
  marker,
  slide_var,
  ndat,
  len = 512,
  weighted = TRUE,
  offset = 1e-04,
  fdobj_norder = 4,
  fdobj_nbasis = 21,
  w_norder = 2,
  w_nbasis = 2
)
}
\arguments{
\item{marker}{column name of marker to normalize}

\item{slide_var}{column name of slide identifier}

\item{ndat}{multiplexed data to normalize. Data assumed to be a data.frame with cell-level data.}

\item{len}{the number of equally spaced points at which the density is to be estimated. See \code{stats::density()} argument \code{n} for more details (default=512)}

\item{weighted}{boolean to determine if weighted mean to be used via \code{weighted.mean.fd()} (default=TRUE)}

\item{offset}{offset from zero when calculating weights (default=0.0001)}

\item{fdobj_norder}{an integer specifying the order of b-splines for the histogram approximation. See \code{fda::create.bspline.basis()} argument \code{norder} for more details. (default=4)}

\item{fdobj_nbasis}{an integer variable specifying the number of basis functions for the histogram approximation. See \code{fda::create.bspline.basis()} argument \code{nbasis} for more details. (default=21)}

\item{w_norder}{an integer specifying the order of b-splines for the linear transformation. See \code{fda::create.bspline.basis()} argument \code{norder} for more details. (default=2)}

\item{w_nbasis}{an integer variable specifying the number of basis functions for the linear transformation. See \code{fda::create.bspline.basis()} argument \code{nbasis} for more details.(default=2)}
}
\value{
Registration adjusted values
}
\description{
Internal function to register one marker
}
