% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{mc_data_sensors}
\alias{mc_data_sensors}
\title{Sensors definition.}
\format{
An object of class \code{environment} of length 28.
}
\usage{
mc_data_sensors
}
\description{
R object of class environment with the definitions of (micro)climatic sensors.
see \linkS4class{mc_Sensor}. Similarly as in case of logger format definitions \linkS4class{mc_DataFormat} it is easy
to add new, sensor here. There is also universal sensor \code{real} where you can store any real values.
}
\details{
Names of items are sensor_ids.
Currently supported sensors:
\itemize{
\item count - result of \code{count} function \code{\link[=mc_agg]{mc_agg()}}
\item coverage - result of \code{coverage} function \code{\link[=mc_agg]{mc_agg()}}
\item Dendro_T - temperature in Tomst dendrometer (°C)
\item Dendro_raw - change in stem size in Tomst dendrometer (raw units) \code{\link[=mc_calc_tomst_dendro]{mc_calc_tomst_dendro()}}
\item dendro_l_um - change in stem size (um) \code{\link[=mc_calc_tomst_dendro]{mc_calc_tomst_dendro()}}
\item FDD - result of function \code{\link[=mc_calc_fdd]{mc_calc_fdd()}}
\item GDD - result of function \code{\link[=mc_calc_gdd]{mc_calc_gdd()}}
\item HOBO_RH - relative humidity in HOBO U23-001A logger (\%)
\item HOBO_T - temperature in HOBO U23 logger (°C)
\item HOBO_extT - external temperature in HOBO U23-004 logger (°C)
\item integer - universal sensor with integer values
\item logical - universal sensor with logical values
\item VWC - volumetric water content in soil (m3/m3)
\item precipitation - (mm)
\item real - universal sensor with real values
\item RH - relative humidity sensor (\%)
\item snow_bool - result of function \code{\link[=mc_calc_snow]{mc_calc_snow()}}
\item snow_fresh - fresh snow height (cm)
\item snow_total - total snow height (cm)
\item sun_shine - time of sun shine (hours)
\item T_C - universal temperature sensor (°C)
\item Thermo_T - temperature sensor in Tomst Thermologger (°C)
\item TMS_T1 - soil temperature sensor in Tomst TMS (°C)
\item TMS_T2 - surface temperature sensor in Tomst TMS (°C)
\item TMS_T3 - air temperature sensor in Tomst TMS (°C)
\item TMS_moist - soil moisture sensor in Tomst TMS (raw TMS units)
\item wind - wind speed (m/s)
}
}
\keyword{datasets}
