% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_pairwise_test.R
\name{stat_pairwise_test}
\alias{stat_pairwise_test}
\title{Pairwise Conservation Test}
\usage{
stat_pairwise_test(phyex_set, modules, alternative = c("greater", "less"), ...)
}
\arguments{
\item{phyex_set}{A PhyloExpressionSet object}

\item{modules}{A named list with elements 'contrast1' and 'contrast2' containing
stage indices for each contrast group}

\item{alternative}{Character string specifying the alternative hypothesis:
"greater" (contrast1 > contrast2) or "less" (contrast1 < contrast2)}

\item{...}{Additional arguments passed to stat_generic_conservation_test}
}
\value{
A ConservationTestResult object with pairwise test results
}
\description{
Test for significant differences in transcriptomic index values
between two groups of developmental stages.
}
\details{
The pairwise test compares the mean transcriptomic index values between two
groups of developmental stages. This is useful for testing specific hypotheses
about differences in gene age composition between developmental periods.
}
\examples{
# Define contrast groups
modules <- list(contrast1 = 1:3, contrast2 = 4:7)
result <- stat_pairwise_test(example_phyex_set, modules, alternative = "greater")

}
\seealso{
\code{\link{stat_generic_conservation_test}}
}
\author{
Jaruwatana Sodai Lotharukpong
}
