% Generated by roxygen2 (4.0.2): do not edit by hand
\name{plot.mycor}
\alias{plot.mycor}
\title{Plot for an object of class "mycor"}
\usage{
\method{plot}{mycor}(x, ..., groups = -1, type = 1)
}
\arguments{
\item{x}{an object of class "mycor"}

\item{...}{further arguments to be passed to \code{\link[graphics]{pairs}} or
\code{\link[lattice]{parallelplot}}(in case of "type" argument is 4).}

\item{groups}{a variable to be evaluated in a data.frame x$df, expected to
act as a grouping variable within each panel, typically used to
distinguish different groups by varying graphical parameters like color and line type.}

\item{type}{specify the type of plot
  \describe{
     \item{1}{makes plot with \code{\link[graphics]{pairs}}}
     \item{2}{makes plot with \code{\link[graphics]{pairs}} using
           \code{\link{panel.hist}} as a diagonal panel}
     \item{3}{makes plot with \code{\link[graphics]{pairs}} using
           \code{\link{panel.cor}} as a upper panel}
     \item{4}{makes plot with \code{\link[lattice]{parallelplot}} using
           \code{\link{panel.cor}} as a upper panel}
}}
}
\description{
Plot for an object of class "mycor"
}
\examples{
out=mycor(iris)
 plot(out)
 plot(out, groups=Species)
 plot(out,type=2,groups=species)
 out1=mycor(mtcars[1:5],alternative="greater",methods="kendall",
            conf.level=0.95)
 plot(out1,type=3)
 plot(out1,type=4,groups=cyl)
}

