% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intensity.R
\name{MeanIntensity}
\alias{MeanIntensity}
\alias{MeanIntensityTxtFolder}
\alias{MeanIntensities}
\title{Calculate mean intensity from image series.}
\usage{
MeanIntensity(arr, mst = NULL, filt = NULL, skip.consts = FALSE,
  verbose = FALSE)

MeanIntensityTxtFolder(folder.path = ".", mst = NULL, ext = "tif",
  mcc = parallel::detectCores(), verbose = TRUE)

MeanIntensities(arr3d.list, mst = NULL, skip.consts = FALSE, fail = NA,
  filt = NULL, verbose = FALSE, mcc = parallel::detectCores())
}
\arguments{
\item{arr}{An array, can be 3- or 4-dimensional. The first two slots give the
x- and y-cordinates of pixels respectively. If the array is 3-dimensional,
the third slot gives the index of the frame. If it is 4-dimensional, the
third slot indexes the channel and the fourth indexes the frame in the
stack.. To perform this on a file that has not yet been read in, set this
argument to the path to that file (a string).}

\item{mst}{Do you want to apply an intensity threshold prior to calculating
mean intensities (via \code{\link[autothresholdr:mean_stack_thresh]{autothresholdr::mean_stack_thresh()}})? If so, set your
thresholding \emph{method} here. Pixels failing to exceed the threshold are
set to \code{NA}.}

\item{filt}{Do you want to smooth (\code{filt = 'smooth'}) or median (\code{filt = 'median'}) filter the mean intensity image using \code{\link[=SmoothFilterB]{SmoothFilterB()}} or
\code{\link[=MedianFilterB]{MedianFilterB()}} respectively? If selected, these are invoked here with a
filter radius of 1 and with the option \code{na_count = TRUE}. If you want to
smooth/median filter the mean intensity image in a different way, first
calculate the mean intensities without filtering (\code{filt = NULL}) using this
function and then perform your desired filtering routine on the result.}

\item{skip.consts}{An image array with only one value (a 'constant array')
won't threshold properly. By default the function would give an error, but
by setting this parameter to \code{TRUE}, the array would instead be skipped
(the function will return the original array) and give a warning.}

\item{verbose}{If arr is specified as a file name, print a message to tell
the user that that file is now being processed (useful for
\code{MeanIntensityTxtFolder}, does not work with multiple cores) and to tell
when \code{MeanIntensityTxtFolder} is done.}

\item{folder.path}{The path (relative or absolute) to the folder you wish to
process.}

\item{ext}{The file extension of the images in the folder that you wish to
process. You must wish to process all files with this extension; if there
are files that you don't want to process, take them out of the folder. The
default is for tiff files. Do not use regular expression in this argument.}

\item{mcc}{The number of parallel cores to use for the processing.}

\item{arr3d.list}{A list of 3-dimensional arrays. To perform this on files
that have not yet been read in, set this argument to the path to these
files (a character vector).}

\item{fail}{If thresholding is done, to which value should pixels not
exceeeding the threshold be set?}
}
\value{
\code{MeanIntensity} returns a matrix, the mean-intensity image.
\code{MeanIntensities} returns a list of these. The result of
\code{MeanIntensityTxtFolder} is csv files written to disk (in the same folder
as the input images).
}
\description{
Given a time stack of images, \code{MeanIntensity} calculates the mean intensity
for each pixel, returning a matrix. \code{MeanIntensityTxtFolder} does this for
every image in a folder, writing the results as text files via
\code{\link[=WriteImageTxt]{WriteImageTxt()}}.
}
\examples{
library(EBImage)
library(magrittr)
img <- ReadImageData(system.file('extdata', '50.tif', package = 'nandb'))
display(normalize(img[, , 1]), method = 'raster')
mean.intensity <- MeanIntensity(img, mst = 'Huang', filt = 'median')
display(normalize(mean.intensity), method = 'r')
two.channel.img <- abind::abind(img, img, along = 4) \%>\% aperm(c(1, 2, 4, 3))
mint.2ch <- MeanIntensity(two.channel.img, mst = "h", filt = "med")
setwd(tempdir())
img <- ReadImageData(system.file('extdata', '50.tif', package = 'nandb'))
WriteIntImage(img, '50.tif')
WriteIntImage(img, '50again.tif')
MeanIntensityTxtFolder(mcc = 2)

img.paths <- rep(system.file('extdata', '50.tif', package = 'nandb'), 2)
mean.intensities <- MeanIntensities(img.paths, mst = 'Huang', mcc = 2)

}
