% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{PillarsDF}
\alias{PillarsDF}
\title{Make each pillar of a 3D array into a column of a tibble}
\usage{
PillarsDF(arr3d)
}
\arguments{
\item{arr3d}{A 3-dimensional array.}
}
\value{
A \link[tibble:tibble]{tibble}.
}
\description{
Create a data frame (tibble) where pillar \code{[i, j, ]} is column \code{i + n1 *
(j - 1)} with column name "i_j" (we use an underscore here rather than a
comma because a comma is the delimiter in csv files so writing this data
frame to a csv could cause confusion).
}
\examples{
arr <- array(1:27, dim = rep(3, 3))
print(arr)
ListPillars(arr)
PillarsDF(arr)

}
