% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aio.R
\name{send_aio}
\alias{send_aio}
\alias{send_aio.nanoSocket}
\alias{send_aio.nanoContext}
\alias{send_aio.nanoStream}
\title{Send Async}
\usage{
send_aio(con, data, mode = c("serial", "raw"), timeout = -2L)

\method{send_aio}{nanoSocket}(con, data, mode = c("serial", "raw"), timeout = -2L)

\method{send_aio}{nanoContext}(con, data, mode = c("serial", "raw"), timeout = -2L)

\method{send_aio}{nanoStream}(con, data, mode = "raw", timeout = -2L)
}
\arguments{
\item{con}{a Socket, Context or Stream.}

\item{data}{an object (a vector, if mode = 'raw').}

\item{mode}{[default 'serial'] for sending serialised R objects, or 'raw' for
sending vectors of any type (converted to a raw byte vector for sending).
For Streams, 'raw' is the only option and any other value is ignored. Use
'serial' for perfect reproducibility within R, although 'raw' must be used
when interfacing with external applications that do not understand R
serialisation.}

\item{timeout}{(optional) integer value in milliseconds. If unspecified, the
default of -2L uses a socket-specific default, which is usually the same
as no timeout.}
}
\value{
A 'sendAio' (object of class 'sendAio').
}
\description{
Send data asynchronously over a connection (Socket, Context or Stream).
}
\details{
Async send is always non-blocking and returns a 'sendAio'
    immediately.

    For a 'sendAio', the send result is available at \code{$result}. An
    'unresolved' logical NA is returned if the async operation is yet to
    complete, The resolved value will be zero on success, or else an integer
    error code.

    To wait for and check the result of the send operation, use
    \code{\link{call_aio}} on the returned 'sendAio' object.

    Alternatively, to stop the async operation, use \code{\link{stop_aio}}.
}
\examples{
pub <- socket("pub", dial = "inproc://nanonext")

res <- send_aio(pub, data.frame(a = 1, b = 2), timeout = 100)
res
res$result

res <- send_aio(pub, "example message", mode = "raw", timeout = 100)
call_aio(res)$result

close(pub)

}
