library(nbpMatching)
context("Distance Matrix")

test_that("distancematrix generates errors when expected", {
  testthat::skip_on_cran()
  x <- as.matrix(sample(16), nrow=4)
  expect_error(distancematrix(x))
  x <- as.matrix(dist(sample(1:25, 8, replace=TRUE)))
  expect_error(distancematrix(x[FALSE,FALSE]))
  expect_error(distancematrix(x[,1:6]))
  expect_warning(distancematrix(x[,-1]))
  expect_error(distancematrix('nofile.csv'))
  expect_error(distancematrix())
  expect_error(distancematrix(list(x)))
  expect_error(expect_warning(distancematrix(cbind(x,LETTERS[1:8]))))
  dm <- distancematrix(x)
  expect_error(dm[1,1] <- 0)
  expect_error(dm[1] <- 0)
  expect_error(dm[[1,1]] <- 0)
  expect_error(diag(dm) <- NA)
})
