% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncdfDimensionNumeric.R
\name{has_bounds,ncdfDimensionNumeric-method}
\alias{has_bounds,ncdfDimensionNumeric-method}
\title{Does the dimension have 'bounds' set?}
\usage{
\S4method{has_bounds}{ncdfDimensionNumeric}(x)
}
\arguments{
\item{x}{The \code{ncdfDimension} object to query.}
}
\value{
Logical to flag if bounds have been set or not.
}
\description{
Does the dimension have 'bounds' set?
}
\examples{
fn <- system.file("extdata",
                  "pr_day_EC-Earth3-CC_ssp245_r1i1p1f1_gr_20240101-20241231_vncdfCF.nc",
                  package = "ncdfCF")
ds <- open_ncdf(fn)
lon <- ds[["lon"]]
has_bounds(lon)
}
