% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncpen_cpp_wrap.R
\name{coef.ncpen}
\alias{coef.ncpen}
\title{Extract the coefficients from an \code{ncpen} object}
\usage{
\method{coef}{ncpen}(object, ...)
}
\arguments{
\item{object}{Fitted \code{ncpen} object.}

\item{...}{Other parameters to coef. Not supported.}
}
\value{
The coefficients \code{\link{matrix}}.
}
\description{
This function returns the coefficients matrix for all lambda values.
}
\examples{
s0 = sam.gen.fun(n=100,p=20,q=10,bmin=0.5,bmax=1,corr=0.5, seed = 1234)
x.mat = s0$x.mat
y.vec = s0$y.vec

fit = ncpen(y.vec=y.vec, x.mat=x.mat, family="gaussian")
coef(fit)

}
\references{
Kwon, S., Lee, S. and Kim, Y. (2016). Moderately clipped LASSO. \emph{Computational Statistics and Data Analysis}, \bold{92C}, 53-67.
}
\seealso{
\code{\link{ncpen}}, \code{\link{plot.ncpen}}, \code{\link{predict.ncpen}}
}
\author{
Dongshin Kim, Sunghoon Kwon, Sangin Lee

Maintainer: Dongshin Kim<dongshin.kim@outlook.com>, Sunghoon Kwon<shkwon0522@gmail.com>
}
