% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auc.R
\name{AUC.cv.ncvsurv}
\alias{AUC.cv.ncvsurv}
\alias{AUC}
\title{AUC for cv.ncvsurv objects}
\usage{
\method{AUC}{cv.ncvsurv}(obj, ...)
}
\arguments{
\item{obj}{A \code{cv.ncvsurv} object. You must run \code{cv.ncvsurv()} with the
option \code{returnY=TRUE} in order for \code{AUC()} to work}

\item{...}{For S3 method compatibility; not used}
}
\description{
Calculates the cross-validated AUC (concordance) from a \code{cv.ncvsurv} object.
}
\details{
The area under the curve (AUC), or equivalently, the concordance statistic
(C), is calculated according to the procedure described in van Houwelingen
and Putter (2011). The function calls \code{survival::concordancefit()}, except
except cross-validated linear predictors are used to guard against
overfitting.  Thus, the values returned by \code{AUC.cv.ncvsurv()} will be lower
than those you would obtain with \code{concordancefit()} if you fit the full
(unpenalized) model.
}
\examples{
data(Lung)
X <- Lung$X
y <- Lung$y

cvfit <- cv.ncvsurv(X, y, returnY=TRUE)
head(AUC(cvfit))
lam <- cvfit$lambda
plot(lam, AUC(cvfit), xlim=rev(range(lam)), lwd=3, type='l',
     las=1, xlab=expression(lambda), ylab='AUC')
}
\references{
van Houwelingen H, Putter H (2011). Dynamic Prediction in
Clinical Survival Analysis.  CRC Press.
}
\seealso{
\code{cv.ncvsurv()}, \code{survival::concordancefit()}
}
\author{
Patrick Breheny, Brandon Butcher, and Lawrence Hunsicker
}
