% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/src.R
\name{nday}
\alias{nday}
\title{neat alias of the week day with reference based on current date}
\usage{
nday(date, reference_alias = FALSE)
}
\arguments{
\item{date}{a Date or POSIX time stamp}

\item{reference_alias}{a Boolean. If set to TRUE, a reference alias of week day is shown based
on current date such as Today/Yesterday/Tomorrow/Last/Coming.}
}
\value{
week day of the date in a readable format with reference alias based on current date
}
\description{
neat alias of the week day with reference based on current date
}
\examples{
# Get day of the week of current date without reference alias
x <- Sys.Date()
nday(x, reference_alias = FALSE)
# Get day of the week with reference alias
nday(x, reference_alias = TRUE)
}
