% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complex_filters.R
\name{layer_filter}
\alias{layer_filter}
\title{Multilayer filter}
\usage{
layer_filter(
  y,
  x,
  nfilter = NULL,
  imbalance = TRUE,
  cull = 5,
  force_vars = NULL,
  verbose = FALSE,
  type = c("index", "names", "full")
)
}
\arguments{
\item{y}{Response vector}

\item{x}{Matrix of predictors}

\item{nfilter}{Vector of number of target predictors to keep at each round.
The length of this vector determines the number of rounds of culling.}

\item{imbalance}{Logical whether to assume the dataset is imbalanced, in
which case samples are only culled from the majority class.}

\item{cull}{number of samples to cull at each round}

\item{force_vars}{not implemented yet}

\item{verbose}{whether to show sample IDs of culled individuals at each round}

\item{type}{Type of vector returned. Default "index" returns indices,
"names" returns predictor names.}
}
\value{
Integer vector of indices of filtered parameters (type = "index") or
character vector of names (type = "names") of filtered parameters.
}
\description{
Experimental filter designed for use with imbalanced datasets. Each round a
simple t-test is used to rank predictors and keep a certain number. After
each round a set number of cases are culled determined as the most outlying
cases - those which if used as a cutoff for classification have the smallest
number of misclassified cases. The t-test is repeated on the culled dataset
so that after successive rounds the most influential outlying samples have
been removed and different samples drive the t-test filter.
}
