% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nested.R
\name{nested}
\alias{nested}
\alias{is_nested}
\alias{nested.default}
\alias{nested.model_spec}
\alias{nested.nested_model}
\alias{nested.workflow}
\alias{is_nested.default}
\alias{is_nested.model_spec}
\alias{is_nested.workflow}
\title{Create a Nested Model}
\usage{
nested(x, ...)

is_nested(x, ...)

\method{nested}{default}(x, ...)

\method{nested}{model_spec}(x, allow_par = FALSE, pkgs = NULL, ...)

\method{nested}{nested_model}(x, allow_par = FALSE, pkgs = NULL, ...)

\method{nested}{workflow}(x, allow_par = FALSE, pkgs = NULL, ...)

\method{is_nested}{default}(x, ...)

\method{is_nested}{model_spec}(x, ...)

\method{is_nested}{workflow}(x, ...)
}
\arguments{
\item{x}{A model specification or workflow.}

\item{...}{Not currently used.}

\item{allow_par}{A logical to allow parallel processing over nests during
the fitting process (if a parallel backend is registered).}

\item{pkgs}{An optional character string of R package names that should be
loaded (by namespace) during parallel processing.}
}
\value{
A nested model object, or a workflow containing a nested model.
For \code{is_nested()}, a logical vector of length 1.
}
\description{
\code{nested()} turns a model or workflow into a nested model/workflow.
\code{is_nested()} checks if a model or workflow is nested.
}
\examples{
\dontshow{if (rlang::is_installed("workflows")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

library(parsnip)
library(workflows)

model <- linear_reg() \%>\%
  set_engine("lm") \%>\%
  nested()

model

is_nested(model)

wf <- workflow() \%>\%
  add_model(model)

is_nested(wf)
\dontshow{\}) # examplesIf}
}
