% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ics.R
\name{ics}
\alias{ics}
\title{Induced Conserved Structure (ICS)}
\usage{
ics(network_1_input, network_2_input, alignment, flip = FALSE)
}
\arguments{
\item{network_1_input}{The first network being aligned, which must be in matrix form. If the two
networks are of different sizes, it will be easier to interpret the output if this is the smaller one.}

\item{network_2_input}{The second network, which also must be a matrix.}

\item{alignment}{A matrix, such as is output by the function NetCom, where the first two columns contain
corresponding node IDs for the two networks that were aligned.}

\item{flip}{Defaults to FALSE. Set to TRUE if the first network is larger than the second. This is necessary 
because ICS is not a symmetric measure of alignment quality.}
}
\value{
A number ranging between 0 and 1. If the Induced Conserved Structure is 1, the two networks are
isomorphic (identical) under the given alignment.
}
\description{
Calculates the Induced Conserved Structure proposed by Patro and Kingsford (2012) of an alignment between two networks.
}
\examples{
# Note that ICS is only defined on unweighted networks.
net_one <- round(matrix(runif(25,0,1), nrow=5, ncol=5))
net_two <- round(matrix(runif(25,0,1), nrow=5, ncol=5))

ics(net_two, net_two, align(net_one, net_two)$alignment)

}
\references{
Patro, R., & Kingsford, C. (2012). Global network alignment using multiscale spectral signatures. Bioinformatics, 28(23), 3105-3114.
}
