% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffnet-methods.r
\name{plot.diffnet}
\alias{plot.diffnet}
\title{S3 plotting method for diffnet objects.}
\usage{
\method{plot}{diffnet}(x, y = NULL, t = 1, vertex.color = c(adopt =
  "steelblue", noadopt = "white"), vertex.size = "degree",
  main = "Diffusion network in time \%d",
  minmax.relative.size = getOption("diffnet.minmax.relative.size", c(0.01,
  0.04)), ...)
}
\arguments{
\item{x}{An object of class \code{\link[=diffnet-class]{diffnet}}}

\item{y}{Ignored.}

\item{t}{Integer scalar indicating the time slice to plot.}

\item{vertex.color}{Character scalar/vector. Color of the vertices.}

\item{vertex.size}{Either a numeric scalar or vector of size \eqn{n}, or any
of the following values: "indegree", "degree", or "outdegree" (see details).}

\item{main}{Character. A title template to be passed to sprintf.}

\item{minmax.relative.size}{Passed to \code{\link{rescale_vertex_igraph}}.}

\item{...}{Further arguments passed to \code{\link[igraph:plot.igraph]{plot.igraph}}.}
}
\value{
A matrix with the coordinates of the vertices.
}
\description{
S3 plotting method for diffnet objects.
}
\details{
Plotting is done via the function \code{\link[igraph:plot.igraph]{plot.igraph}}.

When \code{vertex.size} is either of \code{"degree"}, \code{"indegree"}, or
\code{"outdegree"}, \code{vertex.size} will be replace with \code{dgr(.,cmode = )}
so that the vertex size reflects the desired degree.

The argument \code{minmax.relative.size} is passed to \code{\link{rescale_vertex_igraph}}
which adjusts \code{vertex.size} so that the largest and smallest vertices
have a relative size of \code{minmax.relative.size[2]} and
\code{minmax.relative.size[1]} respectively with respect to the x-axis.
}
\examples{

data(medInnovationsDiffNet)
plot(medInnovationsDiffNet)


}
\seealso{
Other diffnet methods: \code{\link{\%*\%}},
  \code{\link{as.array.diffnet}}, \code{\link{c.diffnet}},
  \code{\link{diffnet-arithmetic}},
  \code{\link{diffnet-class}}, \code{\link{diffnet_index}},
  \code{\link{summary.diffnet}}
}
\author{
George G. Vega Yon
}
