% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rescaleNetwork.R
\name{rescaleNetwork}
\alias{rescaleNetwork}
\title{Rescale network}
\usage{
rescaleNetwork(x, method = "global2")
}
\arguments{
\item{x}{[\code{Network}]\cr
Network.}

\item{method}{[\code{character(1)}]\cr
Rescaling method which actually modifies the coordinates.
Currently there are three methods available:
\describe{
  \item{by.dimension}{Scaling is performed for each dimension independently.}
  \item{global}{Here we shift all the points toward the origin by the minimum of both
  x and y coordiantes and devide by the range of global maximim and minimum.}
  \item{global2}{Here wer shift - analogously to the \code{by.dimension} strategy -
  dimension wise and devide by the maximum of the ranges in x respectivly y direction.}
}
Default is \code{global2}, which leads to the most \dQuote{natural} rescaling.}
}
\value{
[\code{Network}]
}
\description{
Normalize network coordinates to the unit cube while maintaining
its geography.
}
\examples{
\dontrun{
library(gridExtra)
x = generateClusteredNetwork(n.points = 100L, n.cluster = 4L, name = "Rescaling Demo")

# here we "stretch" the instance x direction to visualize the differences of
# the rescaling mehtods
x$coordinates[, 1] = x$coordinates[, 1] * 10L
x$upper = x$upper * 10L
pls = list(
  autoplot(x) + ggtitle("Original"),
  autoplot(rescaleNetwork(x, method = "by.dimension")) + ggtitle("By dimension"),
  autoplot(rescaleNetwork(x, method = "global")) + ggtitle("Global"),
  autoplot(rescaleNetwork(x, method = "global2")) + ggtitle("Global2")
)
pls$nrow = 1L
do.call(grid.arrange, pls)
}
}

