% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netimpact.R
\name{netimpact}
\alias{netimpact}
\title{Determine the importance of individual studies in network
meta-analysis}
\usage{
netimpact(x, seTE.ignore = 10000, verbose = FALSE)
}
\arguments{
\item{x}{An object of class \code{netmeta}.}

\item{seTE.ignore}{Assumed (large) standard error in order to
mimicking the removal of individual studies from the network
meta-analysis.}

\item{verbose}{A logical indicating whether information on the
estimation progress should be printed.}
}
\value{
An object of class \code{"netimpact"} with corresponding
\code{netgraph} and \code{print} function. The object is a list
containing the following components:
\item{impact.fixed}{A matrix with contributions of individual
  studies (columns) to comparisons (rows) under the fixed effects
  model.}
\item{impact.random}{A matrix with contributions of individual
  studies (columns) to comparisons (rows) under the random effects
  model.}
\item{ignored.comparisons}{List with comparisons of ignored study.}
\item{seTE.ignore, x}{As defined above.}
\item{nets}{List of all network meta-analyses (removing a single
  study).}
\item{version}{Version of R package netmeta used to create object.}
}
\description{
This function measures the importance of individual studies in
network meta-analysis by the reduction of the precision if the
study is removed / ignored from the network.
}
\examples{
data(parkinson)

# Only consider first four studies (to reduce runtime of example)
#
p1 <- pairwise(list(Treatment1, Treatment2, Treatment3),
               n = list(n1, n2, n3),
               mean = list(y1, y2, y3),
               sd = list(sd1, sd2, sd3),
               data = subset(parkinson, Study < 5),
               studlab = Study)

net1 <- netmeta(p1)
ni1 <- netimpact(net1, verbose = TRUE)
ni1

netgraph(ni1)

}
\seealso{
\code{\link{netmeta}}, \code{\link{netgraph.netimpact}},
  \code{\link{print.netimpact}}
}
\author{
Guido Schwarzer \email{sc@imbi.uni-freiburg.de},
  Gerta Rücker \email{ruecker@imbi.uni-freiburg.de}
}
