% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/forceNetwork.R, R/networkD3.R, R/sankeyNetwork.R, R/simpleNetwork.R, R/treeNetwork.R
\name{forceNetworkOutput}
\alias{forceNetworkOutput}
\alias{networkD3-shiny}
\alias{renderForceNetwork}
\alias{renderSankeyNetwork}
\alias{renderSimpleNetwork}
\alias{renderTreeNetwork}
\alias{sankeyNetworkOutput}
\alias{simpleNetworkOutput}
\alias{treeNetworkOutput}
\title{Shiny bindings for networkD3 widgets}
\usage{
forceNetworkOutput(outputId, width = "100\%", height = "500px")

renderForceNetwork(expr, env = parent.frame(), quoted = FALSE)

sankeyNetworkOutput(outputId, width = "100\%", height = "500px")

renderSankeyNetwork(expr, env = parent.frame(), quoted = FALSE)

simpleNetworkOutput(outputId, width = "100\%", height = "500px")

renderSimpleNetwork(expr, env = parent.frame(), quoted = FALSE)

treeNetworkOutput(outputId, width = "100\%", height = "800px")

renderTreeNetwork(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{output variable to read from}

\item{width,height}{Must be a valid CSS unit (like \code{"100\%"},
\code{"400px"}, \code{"auto"}) or a number, which will be coerced to a
string and have \code{"px"} appended.}

\item{expr}{An expression that generates a networkD3 graph}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
  is useful if you want to save an expression in a variable.}
}
\description{
Output and render functions for using networkD3 widgets within Shiny
applications and interactive Rmd documents.
}

