% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_print_plot.R
\name{plot.all.impact}
\alias{plot.all.impact}
\title{Plot "all.impact" objects}
\usage{
\method{plot}{all.impact}(x, order = c("given", "value", "alphabetical"),
  zscore = FALSE, abs_val = FALSE, ...)
}
\arguments{
\item{x}{an output object from an impact function (class \code{all.impact})}

\item{order}{"alphabetical" orders nodes alphabetically, "value" orders nodes from
highest to lowest impact value}

\item{zscore}{logical. Converts raw impact statistics to z-scores for plotting}

\item{abs_val}{logical. Plot absolute values of global strength impacts.
If both abs_val=TRUE and zscore=TRUE, plots the absolute value of the z-scores.}

\item{...}{other plotting specifications (ggplot2)}
}
\description{
Convenience function for generating impact plots
}
\details{
Inputting an object of class \code{global.impact} or \code{structure.impact}
will return a line plot that shows the relative impacts of each node.
Inputting a \code{all.impact} object will return both of these plots simultaneously
}
\examples{
out <- impact(depression[,1:5])
plot(out)
\donttest{
out1 <- impact(depression)
plot(out1)
plot(out1, order="value", zscore=TRUE)
}
}
