% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EIGENnet.R
\name{EIGENnet}
\alias{EIGENnet}
\title{EIGENnet}
\usage{
EIGENnet(qgraph_net, EIGENadj = NULL, S = 1000, burn = 200,
  seed = 1, repulse = F, repulsion = 1, eigenmodelArgs = list(),
  ...)
}
\arguments{
\item{qgraph_net}{an object of type \code{qgraph}}

\item{EIGENadj}{to use a base matrix for the eigenmodel other than the adjacency matrix
stored in \code{qgraph_net}, provide it in this argument}

\item{S}{number of samples from the Markov chain}

\item{burn}{number of initial scans of the Markov chain to be dropped}

\item{seed}{a random seed}

\item{repulse}{logical. Add a small repulsion force with wordcloud package to avoid node overlap?}

\item{repulsion}{scalar for the repulsion force (if repulse=T). Larger values add more repulsion}

\item{eigenmodelArgs}{additional arguments in list format passed to \code{eigenmodel::eigenmodel_mcmc}}

\item{...}{additional arguments passed to \code{qgraph}}
}
\description{
Convenience function for converting a qgraph object to an eigenmodel layout
}
\details{
An eigenmodel can be interpreted based on coordinate placement
of each node. A node in the top right corner scored high on both the first and second
latent components
}
\references{
Jones, P. J., Mair, P., & McNally, R. J. (2018). Visualizing psychological networks: A tutorial in R. Frontiers in Psychology, 9, 1742. https://doi.org/10.3389/fpsyg.2018.01742
}
